/*## ----------------------------------------------------------------------##*/
/*##    システム名        :年金額シミュレーションシステム		   ##*/
/*##    客先名            :農業者年金基金殿                                ##*/
/*##    プログラム名    :年金額シミュレーションシステム                    ##*/
/*##    保存ファイル名    :datas.js                                        ##*/
/*##    担当部課        :東京コンピュータサービス（株）立川支社システム部  ##*/
/*##                                                                       ##*/
/*##    履歴：V1.00        2003/02/21	太田	Create                     ##*/
/*##    履歴：V1.03        2008/12/16	加藤	Update	準備金繰入率変更   ##*/
/*##    履歴：V1.04        2012/02/10	依田	Update	名前入力機能を追加 ##*/
/*##                                                                       ##*/
/*##    現価率修正  2005/03/31	中静    農業者年金基金業務部給付課         ##*/
/*##                2006/03/31	中静    農業者年金基金業務部給付課         ##*/
/*##                2007/03/27	中静    農業者年金基金業務部給付課         ##*/
/*##                2008/03/24	小林    農業者年金基金企画調整室（代理）   ##*/
/*##                2009/03/18	佐藤    農業者年金基金企画調整室（代理）   ##*/
/*##                2011/03/28	笹木    農業者年金基金企画調整室           ##*/
/*##                2012/03/29	笹木    農業者年金基金企画調整室           ##*/
/*##                2013/04/08	齋藤    農業者年金基金企画調整室           ##*/
/*##                2014/03/31	齋藤    農業者年金基金企画調整室           ##*/
/*##                2015/03/31	齋藤    農業者年金基金企画調整室           ##*/
/*##                2016/03/28	齋藤    農業者年金基金企画調整室           ##*/
/*##                2017/03/24	吉田    農業者年金基金企画調整室           ##*/
/*##                2018/03/22	有井    農業者年金基金企画調整室           ##*/
/*##                2020/03/13	有井    農業者年金基金企画調整室           ##*/
/*##                2021/03/17	田中    農業者年金基金企画調整室           ##*/
/*##                2022/03/11	佐藤    農業者年金基金企画調整室           ##*/
/*##                2023/03/07	高谷    農業者年金基金企画調整室           ##*/
/*##                2024/03/27	笠倉    農業者年金基金企画調整室           ##*/
/*##                2025/03/26	笠倉    農業者年金基金企画調整室           ##*/                          
/*##                                                                       ##*/
/*## (c)Copyright 農業者年金基金 All Rights Reserved                       ##*/
/*## ----------------------------------------------------------------------##*/
//###########################################################################
//    加入年月の上限・下限値:
//
//                    設定対象                            変数名
//                    ==========================================================
//                    加入年月に設定できる月の下限        DEFINE_JOIN_FIRSTDATE
//                    ----------------------------------------------------------
//                    加入年月に設定できる月の上限        DEFINE_JOIN_FINALDATE
//                    ----------------------------------------------------------
//
//#############################################################################
DEFINE_JOIN_FIRSTDATE = 200304;
DEFINE_JOIN_FINALDATE = 208712;
//#############################################################################
//    標準設定値    :
//                    設定対象            変数名                    変数値の意味
//                    ==========================================================
//                    予想される利回り    DEFAULT_YEILD            n％
//                    ----------------------------------------------------------
//                    旧制度の            DEFAULT_OLDTYPE            0:いいえ
//                    加入者でしたか？                            1:はい
//                    ----------------------------------------------------------
//                    政策支援の種類        DEFAULT_POLICY            0:通常加入
//                                                                1:加入区分1
//                                                                2:加入区分2
//                                                                3:加入区分3
//                                                                4:加入区分4
//                                                                5:加入区分5
//                                                                6:加入区分6
//                    ----------------------------------------------------------
//                    保険料月額            DEFAULT_PREMIUM            n千円
//                    ----------------------------------------------------------
//                    受給開始年齢
//                    ・農業者老齢年金    DEFAULT_RECIEVEAGE0        n歳
//                    ・特例付加年金        DEFAULT_RECIEVEAGE1        n歳
//                    ----------------------------------------------------------
//#############################################################################
DEFAULT_YEILD = 0.75;
DEFAULT_OLDTYPE = 0;
DEFAULT_JOINTYPE = 0;
DEFAULT_POLICY = 0;
DEFAULT_POLICY2 = 0;
DEFAULT_PREMIUM = 20;
DEFAULT_PREMIUM2 = 10;
DEFAULT_PREMIUM3 = 20;
DEFAULT_RECIEVEAGE0 = 65;
DEFAULT_RECIEVEAGE1 = 65;
//#############################################################################
//    エラーメッセージ:
//                    メッセージ一覧表の項番            対応するメッセージ
//                    =========================================================
//                    項番1                            DEFINE_MESSAGE_0
//                    項番2                            DEFINE_MESSAGE_1
//                    項番3                            DEFINE_MESSAGE_2
//                    項番4                            DEFINE_MESSAGE_3
//                    項番5                            DEFINE_MESSAGE_4
//                    項番6                            DEFINE_MESSAGE_5
//                    項番7                            DEFINE_MESSAGE_6
//                    項番8                            DEFINE_MESSAGE_7
//                    項番9                            DEFINE_MESSAGE_8
//                    項番10                           DEFINE_MESSAGE_9
//                    項番11                           DEFINE_MESSAGE_10
//                    項番12                           DEFINE_MESSAGE_11
//                    項番13                           DEFINE_MESSAGE_12
//                    項番14                           DEFINE_MESSAGE_13
//                    項番15                           DEFINE_MESSAGE_14
//                    項番16                           DEFINE_MESSAGE_15
//                    項番17                           DEFINE_MESSAGE_16
//                    項番18                           DEFINE_MESSAGE_17
//                    項番19                           DEFINE_MESSAGE_18
//                    項番20                           DEFINE_MESSAGE_19
//                    ---------------------------------------------------------
//#############################################################################
DEFINE_MESSAGE_0 = "「加入年月」の設定値が暦に実在しません";
DEFINE_MESSAGE_1 = "「加入年月」は平成15年4月以降の年月を設定してください";
DEFINE_MESSAGE_2 = "「生年月日」の設定値が暦に実在しません";
DEFINE_MESSAGE_3 = "「想定される運用利回り」は0.00％～10.00％の範囲で設定してください";
DEFINE_MESSAGE_4 = "35歳以上の方は20000円未満の保険料での加入はできません";
DEFINE_MESSAGE_5 = "「農業者老齢年金の受給開始年齢」は60歳～75歳の範囲で設定してください";
DEFINE_MESSAGE_6 = "「特例付加年金の受給開始年齢」は60歳～80歳の範囲で設定してください";
DEFINE_MESSAGE_7 = "特例付加年金は、農業者老齢年金よりも先に受給開始することはできませんので、「受給開始年齢」を設定しなおしてください";
DEFINE_MESSAGE_8 = "加入時の年齢は20歳～59歳の範囲で設定してください";
DEFINE_MESSAGE_9 = "加入時の年齢は20歳～59歳の範囲で設定してください";
DEFINE_MESSAGE_10 = "加入時の年齢は20歳～59歳の範囲で設定してください";
DEFINE_MESSAGE_11 = "旧制度に加入されていた方で、昭和22年1月2日以前に生まれた方は政策支援を受けることはできません\n「通常加入」での加入となります";
DEFINE_MESSAGE_12 = "旧制度に加入されていない方で、加入時の年齢が40歳以上の方は政策支援を受けることはできません\n「通常加入」での加入となります";
DEFINE_MESSAGE_13 = "加入時の年齢が35歳以上の方は「加入区分５」での加入はできません";
DEFINE_MESSAGE_14 = "「加入区分６」は平成17年1月以降の加入者には適用されません";
DEFINE_MESSAGE_15 = "「加入区分６」は旧制度に加入されていない方には適用されません";
DEFINE_MESSAGE_16 = "「姓・名」は全角で入力してください";
DEFINE_MESSAGE_17 = "「姓・名（カナ）」を入力する場合、「姓・名」も入力してください";
DEFINE_MESSAGE_18 = "「姓・名（カナ）」にカタカナ以外が入力されました";
DEFINE_MESSAGE_19 = "「?1」は全角?2文字以内で入力してください";
DEFINE_MESSAGE_21 = "選択できる保険料月額の上限は67000円です";
DEFINE_MESSAGE_22 = "20000円未満の保険料を選択して加入される場合、加入年月は令和4年1月以降を選択してください";
DEFINE_MESSAGE_23 = "年齢の設定値が加入時の年齢より下回っているので設定しなおしてください";
DEFINE_MESSAGE_24 = "年齢の設定値が保険料額を変更した年齢より下回っているので設定しなおしてください";
DEFINE_MESSAGE_25 = "１回目の変更と同じ年齢又は下の年齢が入力されていますので入力しなおしてください";
DEFINE_MESSAGE_26 = "今入力された年齢は政策支援加入期間中の年齢ですので入力しなおしてください";
DEFINE_MESSAGE_27 = "1回目の金額を指定してください";
DEFINE_MESSAGE_28 = "1回目の年齢を指定してください";
DEFINE_MESSAGE_29 = "1回目の年齢、金額を指定してください";
DEFINE_MESSAGE_30 = "2回目の金額を指定してください";
DEFINE_MESSAGE_31 = "2回目の年齢を指定してください";
DEFINE_MESSAGE_32 = "2回目の年齢、金額を指定してください";
//#############################################################################
//    65歳における平均死亡年齢[= 65 + (65歳における平均余命)]
//    <第19回生命表(平成12年)より抜粋－小数点2位を四捨五入した>
//    
//    読み方：
//    exception_life = new Array(男性の平均死亡率, 女性の平均死亡率)
//#############################################################################
exception_life = new Array(86.5, 92.0);
//#############################################################################
//    農業者老齢年金の年金現価率
//    <農業者年金基金法施行令（昭和四十五年政令第二百六十六号）第一条第二項の
//                            農林水産大臣が定める予定利率等 別表第三より抜粋>
//    告示日：平成十五年三月三十一日
//    施行日：平成十五年四月一日
//
//
//                            農業者老齢年金の年金原資
//    農業者老齢年金の年額 = ----------------------------
//                            農業者老齢年金の年金現価率
//
//    読み方：
//    selfpaid_coefficient[年齢] = new Array(男性, 女性)
//#############################################################################
selfpaid_coefficient[60] = new Array(23.78772, 26.67106);
selfpaid_coefficient[61] = new Array(23.13441, 26.04597);
selfpaid_coefficient[62] = new Array(22.47514, 25.41485);
selfpaid_coefficient[63] = new Array(21.81039, 24.77623);
selfpaid_coefficient[64] = new Array(21.14091, 24.13073);
selfpaid_coefficient[65] = new Array(20.46682, 23.47891);
selfpaid_coefficient[66] = new Array(19.78263, 22.81712);
selfpaid_coefficient[67] = new Array(19.09364, 22.14949);
selfpaid_coefficient[68] = new Array(18.40123, 21.47427);
selfpaid_coefficient[69] = new Array(17.70584, 20.79384);
selfpaid_coefficient[70] = new Array(17.00742, 20.10837);
selfpaid_coefficient[71] = new Array(16.30861, 19.41794);
selfpaid_coefficient[72] = new Array(15.61070, 18.72320);
selfpaid_coefficient[73] = new Array(14.91225, 18.02394);
selfpaid_coefficient[74] = new Array(14.21382, 17.32015);
selfpaid_coefficient[75] = new Array(13.52830, 16.61932);
//#############################################################################
//    特例付加年金の年金現価率
//    <農業者年金基金法施行令（昭和四十五年政令第二百六十六号）第一条第二項の
//                            農林水産大臣が定める予定利率等 別表第四より抜粋>
//    告示日：平成十五年三月三十一日
//    施行日：平成十五年四月一日
//
//                            特例付加年金の年金原資
//    特例付加年金の年額 = ----------------------------
//                            特例付加年金の年金現価率
//
//    読み方：
//    subsidy_coefficient[年齢] = new Array(男性, 女性)
//#############################################################################
subsidy_coefficient[60] = new Array(22.55384, 26.15619);
subsidy_coefficient[61] = new Array(21.95915, 25.55832);
subsidy_coefficient[62] = new Array(21.36121, 24.95668);
subsidy_coefficient[63] = new Array(20.76105, 24.34722);
subsidy_coefficient[64] = new Array(20.16019, 23.73144);
subsidy_coefficient[65] = new Array(19.55798, 23.11046);
subsidy_coefficient[66] = new Array(18.93831, 22.47567);
subsidy_coefficient[67] = new Array(18.31555, 21.83645);
subsidy_coefficient[68] = new Array(17.69214, 21.18869);
subsidy_coefficient[69] = new Array(17.06776, 20.53699);
subsidy_coefficient[70] = new Array(16.44084, 19.88106);
subsidy_coefficient[71] = new Array(15.81545, 19.22040);
subsidy_coefficient[72] = new Array(15.19199, 18.55545);
subsidy_coefficient[73] = new Array(14.56555, 17.88506);
subsidy_coefficient[74] = new Array(13.93515, 17.20847);
subsidy_coefficient[75] = new Array(13.31925, 16.53574);
subsidy_coefficient[76] = new Array(12.71055, 15.86201);
subsidy_coefficient[77] = new Array(12.10057, 15.18547);
subsidy_coefficient[78] = new Array(11.50373, 14.51496);
subsidy_coefficient[79] = new Array(10.89942, 13.83663);
subsidy_coefficient[80] = new Array(10.30319, 13.16107);
//#############################################################################
//    準備金繰入率
//    <「農業者年金基金の財政運営に係る取扱いについて」
//                        の規定により基金が定めた率より抜粋>
//
//    読み方：
//    special_reserve[0～11] = 
//        new Array(運用成績の範囲[n%未満], 付利準備金繰入率[n%], 調整準備金繰入率[n%])
//                                （↑-1の場合は6.0以上をあらわす）
//#############################################################################
special_reserve[0] = new Array(0.0, 0.0, 0.00);
special_reserve[1] = new Array(1.0, 0.0, 0.00);
special_reserve[2] = new Array(2.0, 0.1, 0.05);
special_reserve[3] = new Array(3.0, 0.2, 0.10);
special_reserve[4] = new Array(4.0, 0.3, 0.15);
special_reserve[5] = new Array(5.0, 0.4, 0.20);
special_reserve[6] = new Array(6.0, 0.5, 0.25);
special_reserve[7] = new Array(7.0, 0.6, 0.30);
special_reserve[8] = new Array(8.0, 0.7, 0.35);
special_reserve[9] = new Array(9.0, 0.8, 0.40);
special_reserve[10] = new Array(10.0, 0.9, 0.45);
special_reserve[11] = new Array(-1, 1.0, 0.50);
//#############################################################################
//  新元号
//############################################################################
textEra2019 = '令和';
DEFINE_MESSAGE_20 = "「加入年月は」" + textEra2019 + "1年5月以降の年月を設定してください。";
