/*## -------------------------------------------------------------------------------##*/
/*##	システム名		:年金額シミュレーションシステム								##*/
/*##	客先名			:農業者年金基金殿											##*/
/*##	プログラム名	:年金額シミュレーションシステム								##*/
/*##	保存ファイル名	:simucalc.js												##*/
/*##	担当部課		:東京コンピュータサービス（株）立川支社システム部			##*/
/*##																				##*/
/*##	履歴：V1.00		2003/03/27	太田	Create									##*/
/*##	履歴：V1.01		2003/04/07	太田	Update									##*/
/*##	履歴：V1.02		2006/02/06	加藤	Update	加入年月=40歳到達月は試算する	##*/
/*##												ように修正						##*/
/*##	履歴：V1.03		2008/12/16	加藤	Update	生年月日を平成に対応			##*/
/*##                                                準備金繰入率の変更				##*/
/*##	履歴：V1.04		2012/02/13	依田    Update    名前入力機能を追加			##*/
/*##																				##*/
/*## (c)Copyright 農業者年金基金 All Rights Reserved								##*/
/*## -------------------------------------------------------------------------------##*/
INITIAL_LOAD = true;
//IEの場合はIMEを起動させないようにする
if (document.createStyleSheet) {
    var s = document.createStyleSheet();
    window.s && s.addRule && s.addRule('input', 'ime-mode:disabled;');
}

//#############################################################################
//    共通関数
//#############################################################################

//#############################################################################
//
//    機能説明    ：    政策支援「通常加入」が選択された場合に
//                    特例付加年金の受給開始年齢を入力不可にする
//
//    パラメータ    ：    なし
//
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2003/02/26    ohta
//
//#############################################################################
function grayout() {
    with(document.entdata){
        if(policy.options[policy.selectedIndex].value == "0"){
            recieveage[1].style.color = "#CCCCCC";
            spflg = false;
        }else{
            recieveage[1].style.color = "#000000";
            spflg = true;
        }
    }
}
//#############################################################################
//
//    機能説明    ：    政策支援の種類の変更時の挙動
//                    1. 通常加入の場合は特例付加年金の受給開始年齢を入力不可にする
//                    2. 印刷用のテキストボックスに選択された値を入れる
//
//    パラメータ    ：    なし
//
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2003/02/28    ohta
//
//#############################################################################
function nextdate(year, month) {
    var date, res;
    TransDateObj = new TransDate(year, month, 1);
    
    //#年月を1ヶ月送る
    year = TransDateObj.Year;
    month = TransDateObj.Month;
    date = joinyearmonth(year, month);
    return [year, month, date];
}

function changefee(agev, date35, byy, bmm, bdd) {
  var AMObj0 = new AgedMonth(byy, bmm, bdd, DEFINE_JOIN_FINALAGE+1);
  var date60 = joinyearmonth(AMObj0.Year, AMObj0.Month);
  var enddate = joinyearmonth(AMObj0.FmrYear, AMObj0.FmrMonth);
  var AMObj3 = new AgedMonth(byy, bmm, bdd, DEFINE_POLICY_AGE_0);
  var splitdate = joinyearmonth(AMObj3.FmrYear, AMObj3.FmrMonth);
  var ag = agev;
  with(document.entdata){
    var jy = joinyear.value;
    var jm = joinmonth.value;
    var yy = parseInt(jy,10);
    var mm = parseInt(jm,10);

    var myMode = (textEra2019 == document.getElementById("text-subscription-ear").innerHTML) ? 2 : 1;    
    yy = decodeera(yy, myMode);
    var year = yy;
    var month = mm;
    var jdate = joinyearmonth(year, month);

    var selectedPolicyValue = policy.value;// policy.options[policy.selectedIndex].value;
    var op = document.getElementById("changefee1age").getElementsByTagName("option");

    if (document.getElementById("join_b").checked == true) {
      console.log('join_b selected...');
      for (var i = 1; i < op.length; i++) {
        op[i].disabled = op[i].value <= 35;
      }
      return;
    }

    var selectIndex = 0;
    var chgdateflg = 0;

    var chgfee1age = changefee1age.value;
    var chgfee2age = changefee2age.value;
    var ca1 = parseInt(chgfee1age, 10);
    var ca2 = parseInt(chgfee2age, 10);

    switch(selectedPolicyValue) {
    case "0":
      for (var i = 1; i < op.length; i++) {
        op[i].disabled = op[i].value <= agev;
        if (op[i].value > agev && selectIndex === 0) selectIndex = i;
      }
      break;
    case "1":
    case "2":
    case "3":
      if(jdate < date35) {
        for(var j = 0, k = 0; k < 2; k++){            
          for(var i = j; jdate <= splitdate; i++){
            if (i != 0 && month == bmm) ag++;
            //#35歳を超えてから121ヶ月目 もしくは 加入時から241ヶ月目か？
            if((chgdateflg == 1 && i-j+1 == DEFINE_POLICY_TERM_1 + 1) || i+1 == DEFINE_POLICY_TERM_0 + 1){
              if (i == DEFINE_POLICY_TERM_0) {
                var aggt = agev > ag ? agev : ag;
                for (var i = 1; i < op.length; i++) {
                  op[i].disabled = op[i].value <= aggt;
//                  if (op[i].value > agev && selectIndex === 0) selectIndex = i;
                }
                return;  
              }
            }
            var next = nextdate(year, month);
            year = next[0];
            month = next[1];
            jdate = next[2];
          }
          splitdate = enddate;
          chgdateflg++;
          j = i;
        }
      } else {

        splitdate = enddate;
        var m121flg = false;
        for(var i = 0; jdate <= splitdate; i++){
          if (i != 0 && month == bmm) ag++;
          //#121ヶ月目か？
          if(i+1 == DEFINE_POLICY_TERM_1 + 1){
            m121flg = true;
            var aggt = agev > ag ? agev : ag;
            for (var i = 1; i < op.length; i++) {
              op[i].disabled = op[i].value <= aggt;
            }
            return;
          }
          var next = nextdate(year, month);
          year = next[0];
          month = next[1];
          jdate = next[2];
        }
      }
      break;
    case "4":
      if(jdate < date35) {
        for(var j = 0, k = 0; k < 2; k++){            
          for(var i = j; jdate <= splitdate; i++){
            if (i != 0 && month == bmm) ag++;
            //#35歳を超えてから121ヶ月目 もしくは 加入時から241ヶ月目か？
            if((chgdateflg == 1 && i-j+1 == DEFINE_POLICY_TERM_1 + 1) || i+1 == DEFINE_POLICY_TERM_0 + 1){
              if (i == DEFINE_POLICY_TERM_0) {
                var aggt = agev > ag ? agev : ag;
                for (var i = 1; i < op.length; i++) {
                  op[i].disabled = op[i].value <= aggt;
//                  if (op[i].value > agev && selectIndex === 0) selectIndex = i;
                }
                return;  
              }
            }
            var next = nextdate(year, month);
            year = next[0];
            month = next[1];
            jdate = next[2];
          }
          splitdate = enddate;
          chgdateflg++;
          j = i;
        }
      } else {
        splitdate = enddate;
        var m121flg = false;
        for(var i = 0; jdate <= splitdate; i++){
          if (i != 0 && month == bmm) ag++;
          //#121ヶ月目か？
          if(i+1 == DEFINE_POLICY_TERM_1 + 1){
            m121flg = true;
            var aggt = agev > ag ? agev : ag;
            for (var i = 1; i < op.length; i++) {
              op[i].disabled = op[i].value <= aggt;
            }
            return;
          }
          var next = nextdate(year, month);
          year = next[0];
          month = next[1];
          jdate = next[2];
        }
      }
      break;
    case "5":
      if(jdate < date35) {
        for(var j = 0, k = 0; k < 2; k++){            
          for(var i = j; jdate <= splitdate; i++){
            if (i != 0 && month == bmm) ag++;
            //#35歳を超えてから121ヶ月目 もしくは 加入時から241ヶ月目か？
            if((chgdateflg == 1 && i-j+1 == DEFINE_POLICY_TERM_1 + 1) || i+1 == DEFINE_POLICY_TERM_0 + 1){
              if (i == DEFINE_POLICY_TERM_0) {
                var aggt = agev > ag ? agev : ag;
                for (var i = 1; i < op.length; i++) {
                  op[i].disabled = op[i].value <= aggt;
//                  if (op[i].value > agev && selectIndex === 0) selectIndex = i;
                }
                return;  
              }
            }
            var next = nextdate(year, month);
            year = next[0];
            month = next[1];
            jdate = next[2];
          }
          splitdate = enddate;
          chgdateflg++;
          j = i;
        }
      } else {
        ag = 0;
        var aggt = agev > ag ? agev : ag;
        for (var i = 1; i < op.length; i++) {
          op[i].disabled = op[i].value <= aggt;
        }
        return;
      }
      break;
    }
  }
}

function puthidechangefee2man() {
    with(document.entdata){
        hidechangefee2man.value = changefee2man.options[changefee2man.selectedIndex].text;
        var op = document.getElementById("changefee2sen").getElementsByTagName("option");
        for (var i = 1; i < op.length; i++) {
          op[i].disabled  = changefee2man.selectedIndex == 5 && (i > 8);
        }
    }
}

function puthidechangefee2sen() {
    with(document.entdata){
        hidechangefee2sen.value = changefee2sen.options[changefee2sen.selectedIndex].text;
    }
}

function puthidechangefee2age() {
    with(document.entdata){
        hidechangefee2age.value = changefee2age.options[changefee2age.selectedIndex].text;
    }
}

function puthidechangefee1man() {
    with(document.entdata){
        hidechangefee1man.value = changefee1man.options[changefee1man.selectedIndex].text;
        var op = document.getElementById("changefee1sen").getElementsByTagName("option");
        for (var i = 1; i < op.length; i++) {
          op[i].disabled  = changefee1man.selectedIndex == 5 && (i > 8);
        }
    }
}

function puthidechangefee1sen() {
    with(document.entdata){
        hidechangefee1sen.value = changefee1sen.options[changefee1sen.selectedIndex].text;
    }
}

function changefee1ageClick() {
  var op = document.getElementById("changefee1age").getElementsByTagName("option");
  with(document.entdata){
    var jy = joinyear.value;
    var jm = joinmonth.value;
    jy = parseInt(jy,10);
    jm = parseInt(jm,10);

    if(!isdate2(jy, jm, 1)){
      alert(DEFINE_MESSAGE_0);
      return false;
    }

    var zero = (jm < 10)? "0" : "";
    var myMode = (textEra2019 == document.getElementById("text-subscription-ear").innerHTML) ? 2 : 1;
    var date = parseInt(String(decodeera(jy, myMode)) + zero + String(jm),10);
    if(date < DEFINE_JOIN_FIRSTDATE || date > DEFINE_JOIN_FINALDATE){
      alert(DEFINE_MESSAGE_1);
      return false;
    }

    var by = birthyear.value;
    var bm = birthmonth.value;
    var bd = birthday.value;
    by = parseInt(by,10);
    bm = parseInt(bm,10);
    bd = parseInt(bd,10);
    var waMode = document.entdata.wareki.options[document.entdata.wareki.selectedIndex].value;
    if(!isdate(by, bm, bd, waMode)){
      alert(DEFINE_MESSAGE_2);
      return false;
    }

    var yy = decodeera(jy, myMode);
    waMode = parseInt(document.entdata.wareki.options[document.entdata.wareki.selectedIndex].value,10);
    var bby = decodeera(by, waMode);    

    //#加入年と月を[YYYYMM]形式で表す
    var mm = parseInt(jm,10);
    year = yy;
    month = mm;

    //#35歳の到達年月を[YYYYMM]形式で表す
    var AMObj1 = new AgedMonth(bby, bm, bd, DEFINE_POLICY_AGE_0);
    var date35 = joinyearmonth(AMObj1.Year, AMObj1.Month);

    // for print
    hidepolicy.value = policy.options[policy.selectedIndex].text;
  } // document.entdata
  var age = calcage(yy, jm, "1", bby, bm, bd);

  //#加入時年齢 < 20ならばエラー
  if(age < DEFINE_JOIN_FIRSTAGE){
    alert(DEFINE_MESSAGE_8);
    return false;
  }
    
  //#加入時年齢 > 59ならばエラー
  if(age > DEFINE_JOIN_FINALAGE){
    alert(DEFINE_MESSAGE_9);
    return false;
  }

  changefee(age, date35, bby, bm, bd);
}

function puthidechangefee1age() {
    var selectedValue = document.getElementById("changefee1age").value;
    with(document.entdata){
        hidechangefee1age.value = changefee1age.options[changefee1age.selectedIndex].text;
        var ageIndex =  changefee1age.selectedIndex;
        var op = document.getElementById("changefee2age").getElementsByTagName("option");
        if (ageIndex == 0) {
          document.getElementById("changefee2age").value = '';
          op[0].setAttribute("selected", "selected");
          for (var i = 1; i < op.length; i++) {
            op[i].disabled  = true;
          }
        } else {
          var selectIndex = 0;
          for (var i = 1; i < op.length; i++) {
            op[i].disabled = op[i].value <= selectedValue;
            if (op[i].value == selectedValue) selectIndex = (i == op.length-1) ? 0 : i+1;
          }
        }
    }
}

function policychanging(){
    grayout();

    if (INITIAL_LOAD) {
      INITIAL_LOAD = false;
      return;
    }

    with(document.entdata){
      // for print
      hidepolicy.value = policy.options[policy.selectedIndex].text;
    } // document.entdata
}

function checkJoinYM() {
  with(document.entdata){
    var jy = joinyear.value;
    var jm = joinmonth.value;
    if(!isdate2(jy, jm, 1)) {
      alert(DEFINE_MESSAGE_0);
      return;
    }
  }
  zero = (jm < 10)? "0" : "";
  var myMode = (textEra2019 == document.getElementById("text-subscription-ear").innerHTML) ? 2 : 1;
  date = parseInt(String(decodeera(jy, myMode)) + zero + String(jm),10);
  if(date < DEFINE_JOIN_FIRSTDATE || date > DEFINE_JOIN_FINALDATE){
    document.outdata.reset();
    alert(DEFINE_MESSAGE_1);
  }
}

function changeJoinyear() {
  checkJoinYM();
}
function changeJoinmonth() {
  checkJoinYM();
}
//function policychanging2(){
//    grayout();
//    with(document.entdata){
//        hidepolicy2.value = policy2.options[policy2.selectedIndex].text;
//    }
//}

//#############################################################################
//
//    機能説明    ：    保険料月額が変更時に、印刷用のテキストボックスに
//                    選択された値を入れる
//
//    パラメータ    ：     単位[0:万、1:千](mode)
//
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2022/12/09    takaya
//
//#############################################################################
function puttohidepre(mode){
    with(document.entdata){
        hidepremium[mode].value = premium[mode].options[premium[mode].selectedIndex].value;
    }
}
function puttohidepre2(mode2){
    with(document.entdata){
        hidepremium10[mode2].value = premium2[mode2].options[premium2[mode2].selectedIndex].value;
    }
}
function puttohidepre3(mode){
    with(document.entdata){
        hidepremium20[mode].value = premium3[mode].options[premium3[mode].selectedIndex].value;
    }
} 

//#############################################################################
//
//    機能説明    ：    「保険料を納付する期間」を変更した時に、印刷用のテキストボックスに
//                    選択された値を入れる
//
//    パラメータ    ：    なし
//
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2023/01/04    takaya
//
//#############################################################################
function termchanging(){
    with(document.entdata){
        hidepremium30.value = supplyTerm.options[supplyTerm.selectedIndex].text;
    }
}

//#############################################################################
//
//    機能説明    ：   加入方法（ＡorＢ）を選択したとき
//                    選択されなかった方法に係る保険料関連の入力を不可にする
//
//    パラメータ    ：    なし
//
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2021/12/01
//
//#############################################################################
function grayout_b(){ //Aを選んだ場合Ｂの各入力欄を入力不可にする
    //グレイアウトさせるＢの各欄の入力値を初期化する
/*  for(i = 0; i < document.entdata.policy2.options.length; i++){
        if(document.entdata.policy2.options[i].value == String(DEFAULT_POLICY2)){
            document.entdata.policy2.options[i].selected = true;
            break;
        }
    }    
*/
    for(i = 0; i < String(DEFAULT_PREMIUM2).length; i++){
        for(j = 0; j < document.entdata.premium2[i].options.length; j++){
            if(document.entdata.premium2[i].options[j].value == String(DEFAULT_PREMIUM2).charAt(i)){
                document.entdata.premium2[i].options[j].selected = true;
                break;
            }
        }
    }    
    for(i = 0; i < String(DEFAULT_PREMIUM3).length; i++){
        for(j = 0; j < document.entdata.premium3[i].options.length; j++){
            if(document.entdata.premium3[i].options[j].value == String(DEFAULT_PREMIUM3).charAt(i)){
                document.entdata.premium3[i].options[j].selected = true;
                break;
            }
        }
    }
    //上記で初期化した値を印刷用テキストボックスにインプット
    policychanging();
/*  policychanging2;*/
    puttohidepre(0);
    puttohidepre(1);
    puttohidepre2(0);
    puttohidepre2(1);
    puttohidepre3(0);
    puttohidepre3(1);
    //Ｂの各欄を入力不可にし、Ａ各欄を入力可能にする（以下のgrayout_aはＡとＢ各欄への処理を逆に行う）
        document.getElementById('manyen2').disabled = true;
        document.getElementById('senyen2').disabled = true;
/*      document.getElementById('policy2').disabled = true; */
        document.getElementById('manyen3').disabled = true;
        document.getElementById('senyen3').disabled = true;
        document.getElementById('policy').disabled = false;
        document.getElementById('manyen').disabled = false;
        document.getElementById('senyen').disabled = false;
}

function grayout_a(){
    for(i = 0; i < document.entdata.policy.options.length; i++){
        if(document.entdata.policy.options[i].value == String(DEFAULT_POLICY)){
            document.entdata.policy.options[i].selected = true;
            break;
        }
    }
    for(i = 0; i < String(DEFAULT_PREMIUM).length; i++){
        for(j = 0; j < document.entdata.premium[i].options.length; j++){
            if(document.entdata.premium[i].options[j].value == String(DEFAULT_PREMIUM).charAt(i)){
                document.entdata.premium[i].options[j].selected = true;
                break;
            }
        }
    }
    policychanging();
/*  policychanging2;*/
    puttohidepre(0);
    puttohidepre(1);
    puttohidepre2(0);
    puttohidepre2(1);
    puttohidepre3(0);
    puttohidepre3(1);
        document.getElementById('policy').disabled = true;
        document.getElementById('manyen').disabled = true;
        document.getElementById('senyen').disabled = true;
        document.getElementById('manyen2').disabled = false;
        document.getElementById('senyen2').disabled = false;
/*      document.getElementById('policy2').disabled = false;*/
        document.getElementById('manyen3').disabled = false;
        document.getElementById('senyen3').disabled = false;
}

//#############################################################################
//
//    機能説明    ：    和暦から西暦を求める
//
//    パラメータ    ：    和暦の年(year)
//                    元号モード[0:昭和、1:平成](era)
//
//    戻り値        ：    西暦の年(ad_year)
//
//    変更履歴    ：    新規作成    2003/02/06    ohta
//
//#############################################################################
function decodeera(year, era){
    var ad_year;
    
    year = parseInt(year,10);
    // V1.03 和暦の選択値により、年齢計算を変更させる。 start
    era = parseInt(era,10);
    // V1.03 和暦の選択値により、年齢計算を変更させる。 end
    switch(era){
    case 0:
        ad_year = year + 1925;
        break;
                    
    case 1:
        ad_year = year + 1988;
        break;
        case 2:
                ad_year = year + 2018;
                break;
    }
    
    return ad_year;
}
//#############################################################################
//
//    機能説明    ：    西暦から和暦を求める
//
//    パラメータ    ：    西暦の年(year)
//                    西暦の月(month)
//                    西暦の日(day)
//
//    戻り値        ：    以下のデータを含んだ配列(wa_year)
//                    ・元号[昭和:0、平成:1]
//                    ・和暦の年
//
//    変更履歴    ：    新規作成    2003/02/26    ohta
//
//#############################################################################
function encodeera(year, month, day){
    var date, zero_m, zero_d;
    var wa_year;
    
    year = parseInt(year,10);
    month = parseInt(month,10);
    day = parseInt(day,10);
    
    zero_m = (parseInt(month,10) < 10)? "0" : "";
    zero_d = (parseInt(day,10) < 10)? "0" : "";
    date = parseInt(String(year) + zero_m + String(month) + zero_d + String(day),10);
    
    if(date <= 19261224){
        wa_year = new Array(-1, -1); 
    
    }else if(date >= 19261225 && date <= 19890107){
        wa_year = new Array(0, year - 1925);
    
    }else if(date >= 19890108 && date < 20190501){
        wa_year = new Array(1, year - 1988);
        }else if(date >= 20190501){
                wa_year = new Array(2, year - 2018);
    }
    
    return wa_year;
}
//#############################################################################
//
//    機能説明    ：    西暦から和暦を求める（年月バージョン）
//
//    パラメータ    ：    西暦の年(year)
//                    西暦の月(month)
//
//    戻り値        ：    以下のデータを含んだ配列(date)
//                    ・元号[昭和:0、平成:1]
//                    ・和暦の年
//
//    変更履歴    ：    新規作成    2003/02/26    ohta
//
//#############################################################################
function encodeera2(year, month){
    var day, date;
    
    if(year == 1926 && month == 12){
        day = 25;
    
    }else if(year == 1989 && month == 1){
        day = 8;
    
    }else{
        day = 1;
    }
    
    date = encodeera(year, month, day);
    
    return date;
}
//#############################################################################
//
//    機能説明    ：    日付が暦に実在するのかを確認する
//
//    パラメータ    ：    年(year)
//                    月(month)
//                    日(day)
//                    元号モード[0:昭和、1:平成](mode)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/06    ohta
//
//#############################################################################
function isdate(year, month, day, mode){
    var date, zero_m, zero_d, mp_y, mp_m, mp_d, reg_y, reg_m, reg_d;
    var DateObj;
        
    mp_y = "(^[0-9][0-9]$|^[1-9]$)";
    mp_m = "(^[0-1][0-9]$|^[1-9]$)";
    mp_d = "(^[0-3][0-9]$|^[1-9]$)";
    
    reg_y = new RegExp(mp_y);
    reg_m = new RegExp(mp_m);
    reg_d = new RegExp(mp_d);
    
    year = String(year);
    month = String(month);
    day = String(day);
    
    //#正規表現に適しているか？
    if(reg_y.test(year) && reg_m.test(month) && reg_d.test(day)){
        year = parseInt(year,10);
        month = parseInt(month,10);
        day = parseInt(day,10);
        
        zero_m = (month < 10)? "0" : "";
        zero_d = (day < 10)? "0" : "";
        date = parseInt(String(year) + zero_m + String(month) + zero_d + String(day),10);
        
        //#元号と年月日にくいちがいがないか？
        if((mode == 0 && date >= 11225 && date <= 640107) || (mode == 1 && date >= 10108)){
            year = decodeera(year, mode);
    
            DateObj = new Date(year, month-1, day);
            
            //#存在する日付か？
            if(year == DateObj.getFullYear()){
                if(month == DateObj.getMonth()+1){
                    if(day == DateObj.getDate()){
                        return true;
                    }
                }
            }
        }
    }
    return false;
}
//#############################################################################
//
//    機能説明    ：    日付が暦に実在するのかを確認する（年月バージョン）
//
//    パラメータ    ：    年(year)
//                    月(month)
//                    元号モード[0:昭和、1:平成](mode)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/26    ohta
//
//#############################################################################
function isdate2(year, month, mode){
    var day, res;
    
    year = parseInt(year,10);
    month = parseInt(month,10);
    
    if(year == 1 && month == 12 && mode == 0){
        day = "25";
    
    }else if(year == 1 && month == 1 && mode == 1){
        day = "8";
    
    }else{
        day = "1";
    }
    
    res = isdate(year, month, day, mode);
    
    return res;
}
//#############################################################################
//
//    機能説明    ：    想定される運用利回りのエラーチェック
//
//    パラメータ    ：    入力された利回り(yld)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/27    ohta
//
//#############################################################################
function isyield(yld){
    var stl, REG;
    
    yld = String(yld);
    
    //#正規表現オブジェクトの実体化
    stl =    "(^[1-9][0-9]$)|"
            + "(^[0-9]$)|"
            + "(^[1-9][0-9]\\.[0-9]{0,2}$)|"
            + "(^[0-9]\\.[0-9]{0,2}$)|"
            + "(^\\.[0-9]{0,2}$)";
    
    REG = new RegExp(stl);
    if(!REG.exec(yld)){
        return false;
    }
    
    yld = parseFloat(yld);
    
    
    if(yld < DEFINE_YIELD_LOWER || yld > DEFINE_YIELD_UPPER){
        return false;
    }
    return true;
}
//#############################################################################
//
//    機能説明    ：    受給開始年齢のエラーチェック
//
//    パラメータ    ：    農業者老齢[0]・特例付加[1]判別フラグ(mode)
//                    受給開始年齢(yld)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/27    ohta
//
//#############################################################################
function isrecieveage(mode, rcva){
    var stl, REG;
    
    rcva = String(rcva);
    
    //#正規表現オブジェクトの実体化
    stl = "(^[1-9][0-9]$)|(^[0-9]$)";
    
    REG = new RegExp(stl);
    if(!REG.exec(rcva) && !(mode == 1 && spflg == false)){
        return false;
    }
    
    rcva = parseInt(rcva,10);
    
    switch(mode){
    case 0:
        if(rcva < DEFINE_RECIEVEAGE0_LOWER || rcva > DEFINE_RECIEVEAGE0_UPPER){
            return false;
        }
        break;
    
    case 1:
        if(spflg && (rcva < DEFINE_RECIEVEAGE1_LOWER || rcva > DEFINE_RECIEVEAGE1_UPPER)){
            return false;
        }
        break;
    }
    return true;
}
//#############################################################################
//
//    機能説明    ：    任意の年月から数ヶ月移った時の年と月を求める
//
//    パラメータ    ：    任意の年(year)
//                    任意の月(month)
//                    移った月(cnt)
//
//    属性        ：    移った時の年(Year)
//                    移った時の月(Month)
//
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2003/02/14    ohta
//
//#############################################################################
function TransDate(year, month, cnt){
    var DateObj;
    year = parseInt(year,10);
    month = parseInt(month,10);
                
    DateObj = new Date(year, month + cnt -1, 1);
    
    this.Year = DateObj.getFullYear();
    this.Month = DateObj.getMonth() + 1;
}
//#############################################################################
//
//    機能説明    ：    ある数字の小数点以下の桁数と小数点を省いた文字列を得る
//
//    パラメータ    ：    数字(number)
//                    
//    戻り値        ：    以下のデータを含んだ配列(res)    
//                    ・小数点以下の桁数
//                    ・小数点を省いた数値の文字列
//
//    変更履歴    ：    新規作成    2003/02/21    ohta
//
//#############################################################################
function getfigure(number){
    var res;
    number = "" + number;
    if(number.indexOf(".") == -1){
        res = new Array(0, parseInt(number,10));
        return res;
    }
    
    var po = number.split(".")[1].length;
    var st = number.split(".").join("");
    
    for(var i = 0; i < st.length; i++){
        if(st.charAt(0) == "0"){
            st = st.substr(1, st.length-1);
        }
    }
    
    res = new Array(po, parseInt(st,10));
    return res;
}
//#############################################################################
//
//    機能説明    ：    誤差を出さないように小数の計算をする
//
//    パラメータ    ：    数字1(numberA)
//                    算術文字[+-*/](type)
//                    数字2(numberB)
//
//    戻り値        ：    計算結果
//
//    変更履歴    ：    新規作成    2003/02/21    ohta
//
//#############################################################################
function demicalcalc(numberA, type, numberB){
    var h = (type == "*")? "+": "-";
    var c = new Array(getfigure(numberA), getfigure(numberB));
    var A = c[0][1];
    var B = c[1][1];
    var pointA = c[0][0];
    var pointB = c[1][0];
        
    if(type == "*" || type == "/"){
        var k1 = eval("numberA" + type + "numberB");
        var k2 = eval("(A" + type + "B)");
        if(getfigure(k1)[1] == k2){
            return k1;
        }else{
            return ((pointA + pointB == 0)? k1: eval(k2 + "/Math.pow(10, pointA" + h + "pointB)"));
        }
    }else if(type == "+" || type == "-"){
        var pointL = pointA;
        if(pointA < pointB){
            pointL = pointB;
        }
        numberA = demicalcalc(numberA, "*", Math.pow(10, pointL));
        numberB = demicalcalc(numberB, "*", Math.pow(10, pointL));
        return eval("numberA" + type + "numberB")/Math.pow(10, pointL);
    }
}
//#############################################################################
//
//    機能説明    ：    小数点第2位以上を対象として数値を整数値に切り上げる
//
//    パラメータ    ：    数値(num)
//
//    戻り値        ：    切り上げ後の数値(intpart)
//
//    変更履歴    ：    新規作成    2003/02/24    ohta
//
//#############################################################################
function roundup(num){
    var intpart, dempart, i;
    
    num = String(num);
    if(num.indexOf(".") == -1){
        return parseInt(num,10);
    }
    intpart = parseInt(num.split(".")[0],10);
    dempart = num.split(".")[1];
    for(i = 0; dempart.length > i && i <= 1; i++){
        if(parseInt(dempart.charAt(i),10) > 0){
            intpart = (intpart > 0)? intpart+1 : intpart;
            break;
        }
    }
    return intpart;
}
//#############################################################################
//
//    機能説明    ：    小数点第4位以上を対象として数値を整数値に切り捨てる
//
//    パラメータ    ：    数値(num)
//
//    戻り値        ：    切り上げ後の数値(intpart)
//
//    変更履歴    ：    新規作成    2003/02/24    ohta
//
//#############################################################################
function rounddown(num){
    var intpart, dempart, i;
    
    num = String(num);
    if(num.indexOf(".") == -1){
        return parseInt(num,10);
    }
    intpart = parseInt(num.split(".")[0],10);
    dempart = num.split(".")[1];
    for(i = 0; dempart.length > i && i <= 3; i++){
        if(parseInt(dempart.charAt(i),10) > 0){
            intpart = (intpart > 0)? intpart : intpart-1;
            break;
        }
    }
    return intpart;
}
//#############################################################################
//
//    機能説明    ：    数値の2桁目（十の位）を四捨五入する
//
//    パラメータ    ：    数値(num)
//
//    戻り値        ：    切り上げ後の数値(res)
//
//    変更履歴    ：    新規作成    2003/02/24    ohta
//
//#############################################################################
function roundup2(num){
    var intpart, flg, minus, res, overhundred;
    
    num = String(num);
    intpart = (num.indexOf(".") == -1)?    num : num.split(".")[0];
    if(intpart.indexOf("-") == -1){
        flg = true;
        minus = "";
    }else{
        flg = false;
        minus = "-";
        intpart = intpart.split("-")[1];
    }
        
    if(!intpart.length){
        res = flg? 0: -100;
    }else if(intpart.length < 2){
        res = flg? 0: -100;
    }else if(intpart.length == 2){
        if(parseInt(intpart,10) < 50){
            res = flg? 0: -100;
        }else{
            res = flg? 100: 0;
        }
    }else{
        overhundred = parseInt(minus + intpart.substr(0, intpart.length - 2) + "00",10);
        if(parseInt(intpart.substr(intpart.length-2, 2),10) < 50){
            res = flg? overhundred : overhundred -100;
        }else{
            res = flg? overhundred + 100 : overhundred;
        }
    }
    
    return res;
}
//#############################################################################
//
//    機能説明    ：    数値を整数値に切り捨てる(対象範囲の指定なし)
//
//    パラメータ    ：    数値(num)
//
//    戻り値        ：    切り上げ後の数値(intpart)
//
//    変更履歴    ：    新規作成    2003/02/26    ohta
//
//#############################################################################
function rounddown2(num){
    var intpart, dempart, i;
    
    num = String(num);
    if(num.indexOf(".") == -1){
        return parseInt(num,10);
    }
    intpart = parseInt(num.split(".")[0],10);
    dempart = num.split(".")[1];
    for(i = 0; dempart.length > i; i++){
        if(parseInt(dempart.charAt(i),10) > 0){
            intpart = (intpart > 0)? intpart : intpart-1;
            break;
        }
    }
    return intpart;
}
//#############################################################################
//
//    機能説明    ：    数値を3ケタごとにカンマで区切る
//
//    パラメータ    ：    数値(num)
//
//    戻り値        ：    カンマで区切った文字列(str)
//
//    変更履歴    ：    新規作成    2003/02/27    ohta
//
//#############################################################################
function putcomma(num){
    var str, i, charstt, charnum;
    var part = new Array();
    
    str = String(num);
    
    for(i = 0;i*3+3 <= str.length+2;i++){
        charstt = (str.length - (i*3+3) >= 0)? str.length-(i*3+3) : 0;
        charnum = (str.length - (i*3+3) >= 0)? 3: 3 - ((i*3+3) - str.length);
        part[i] = str.substr(charstt, charnum);
    }
    part.reverse();
    str = part.join(",");
    
    return str;
}
//#############################################################################
//
//    機能説明    ：    二つの年月から月数の差分をとる
//
//    パラメータ    ：    年1(year)
//                    月1(month)
//                    年2(ex_year)
//                    月2(ex_month)
//
//    戻り値        ：    月数の差分(diff_m)
//
//    変更履歴    ：    新規作成    2003/03/25    ohta
//
//#############################################################################
function diffmonth(year, month, ex_year, ex_month){
    var diff_y, diff_m;
    year = parseInt(year,10);
    month = parseInt(month,10);
    ex_year = parseInt(ex_year,10);
    ex_month = parseInt(ex_month,10);
    
    if(year == ex_year){
        diff_m = ex_month - month;
        
    }else{
        diff_y = ex_year - year;
        diff_m = diff_y * 12 + ex_month - month;
    }
    
    return diff_m;
}
//#############################################################################
//    標準設定に関する動作
//#############################################################################
//#############################################################################
//
//    機能説明    ：    加入年月に現在の年月を設定する
//
//    パラメータ    ：    なし
//
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2003/01/31    ohta
//
//#############################################################################
function setmonth(){
    //#現在の年・月を求める
    var DateObj, yy, mm;
    DateObj = new Date();
    yy = DateObj.getFullYear();
    mm = DateObj.getMonth() + 1;
        if ((yy >= 2019 && mm >= 5) || (yy > 2019)) {
            document.getElementById("text-subscription-ear").innerHTML = textEra2019; //"newtext";
        }
        else {
            document.getElementById("text-subscription-ear").innerHTML = "平成";
        }
    //#VALUE値に代入
    document.entdata.joinyear.value = encodeera2(yy, mm)[1];
    document.entdata.joinmonth.value = mm;
}
//#############################################################################
//
//    機能説明    ：    入力フォームを標準設定にする
//
//    パラメータ    ：    なし
//
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2003/02/05    ohta
//
//#############################################################################    
function setdefault(){
    var i, j;
    
    //#特例付加年金の受給開始年齢を入力可にする
    spflg = true;
    
    //#加入年月に現在の年月を設定する
    setmonth();
    
    //#その他のフォームを標準設定にする
//    document.entdata.yield.value = DEFAULT_YEILD;    ##2003/04/07 想定される運用利回りのデフォルト値は表示しない
         
    for(i = 0; i < document.entdata.oldtype.length; i++){
        if(document.entdata.oldtype[i].value == String(DEFAULT_OLDTYPE)){
            document.entdata.oldtype[i].checked = true;
            break;
        }
    }
        
    for(i = 0; i < document.entdata.policy.options.length; i++){
        if(document.entdata.policy.options[i].value == String(DEFAULT_POLICY)){
            document.entdata.policy.options[i].selected = true;
            break;
        }
    }
/*    for(i = 0; i < document.entdata.policy2.options.length; i++){
        if(document.entdata.policy2.options[i].value == String(DEFAULT_POLICY2)){
            document.entdata.policy2.options[i].selected = true;
            break;
        }
    }
*/    
    for(i = 0; i < String(DEFAULT_PREMIUM).length; i++){
        for(j = 0; j < document.entdata.premium[i].options.length; j++){
            if(document.entdata.premium[i].options[j].value == String(DEFAULT_PREMIUM).charAt(i)){
                document.entdata.premium[i].options[j].selected = true;
                break;
            }
        }
    }
    for(i = 0; i < String(DEFAULT_PREMIUM2).length; i++){
        for(j = 0; j < document.entdata.premium2[i].options.length; j++){
            if(document.entdata.premium2[i].options[j].value == String(DEFAULT_PREMIUM2).charAt(i)){
                document.entdata.premium2[i].options[j].selected = true;
                break;
            }
        }
    }    
    for(i = 0; i < String(DEFAULT_PREMIUM3).length; i++){
        for(j = 0; j < document.entdata.premium3[i].options.length; j++){
            if(document.entdata.premium3[i].options[j].value == String(DEFAULT_PREMIUM3).charAt(i)){
                document.entdata.premium3[i].options[j].selected = true;
                break;
            }
        }
    }

    document.entdata.premium.value = DEFAULT_PREMIUM;
//	document.entdata.recieveage[0].value = DEFAULT_RECIEVEAGE0;
//	document.entdata.recieveage[1].value = DEFAULT_RECIEVEAGE1;
    
    document.getElementById('join_a').checked = true;
    document.getElementById('join_b').checked = false;
    document.getElementById('manyen2').disabled = true;
    document.getElementById('senyen2').disabled = true;
/*  document.getElementById('policy2').disabled = true;*/
    document.getElementById('manyen3').disabled = true;
    document.getElementById('senyen3').disabled = true;
    document.getElementById('policy').disabled = false;
    document.getElementById('manyen').disabled = false;
    document.getElementById('senyen').disabled = false;
	
    document.outdata.outname.value = "";
    document.outdata.outnamekana.value = "";
    document.getElementById("resultTitle1").style.display="none";
    document.getElementById("resultTitle2").style.display="";
    for(i = 0; i <= 1; i++){
        puttohidepre(i);
        puttohidepre2(i);
        puttohidepre3(i);    
    }
    policychanging();
    termchanging();
    puthidechangefee1age();
    puthidechangefee1man();
    puthidechangefee1sen();
    puthidechangefee2age();
    puthidechangefee2man();
    puthidechangefee2sen();
<!--policychanging2();-->
}

//#############################################################################
//    入力フォームの操作ボタンに関する動作
//#############################################################################

//#############################################################################
//
//    機能説明    ：    加入年月を1ヶ月ごとに増減する
//
//    パラメータ    ：    0:減らす、1:増やす(mode)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/01/31    ohta
//
//#############################################################################
function changemonth(mode){
    var yy, mm, CDateObj, TransDateObj, cnt, zero, date;
    yy = document.entdata.joinyear.value;
    mm = document.entdata.joinmonth.value;
    var myMode = 1;
        if (textEra2019 == document.getElementById("text-subscription-ear").innerHTML)
            myMode = 2;
    if(!isdate2(yy, mm, 1)){
        return false;
    }
    
    yy = decodeera(yy, myMode);
    switch(mode){
    case 0:
        cnt = -1;
        break;
    
    case 1:
        cnt = 1;
        break;
        
    }
    
    TransDateObj = new TransDate(yy, mm, cnt);
    yy = TransDateObj.Year;
    mm = TransDateObj.Month;
    
    zero = (mm < 10)? "0" : "";
    date = parseInt(String(yy) + zero + String(mm),10);
        if ((yy == 2019 && mm >= 5) || (yy > 2019)) {
            document.getElementById("text-subscription-ear").innerHTML = textEra2019; //"newtext";
        }
        else {
            document.getElementById("text-subscription-ear").innerHTML = "平成";
        }
    if(encodeera2(yy, mm)[0] >= 1 && date >= DEFINE_JOIN_FIRSTDATE && date <= DEFINE_JOIN_FINALDATE){
        //#VALUE値に代入
        document.entdata.joinyear.value = encodeera2(yy, mm)[1];
        document.entdata.joinmonth.value = mm;
        return true;
    }
    return false;
}
//#############################################################################
//
//    機能説明    ：    保険料月額を1000円ごとに増減する
//
//    パラメータ    ：    0:減らす、1:増やす(mode)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/06    ohta
//
//#############################################################################
/*
function changepremium(mode){
    var price;
    
    price = document.entdata.premium.value;
    
    if(isNaN(price)){
        return false;
    }
    
    price = parseInt(price,10);
    
    switch(mode){
    case 0:
        price--;
        break;
    
    case 1:
        price++;
        break;
    }
    
    if(price >= 20 && price <= 67){
        //#VALUE値に代入
        document.entdata.premium.value = price;
    }else{
        return false;
    }
    return true;
}
*/
//#############################################################################
//
//    機能説明    ：    受給開始年齢を1歳ごとに増減する
//
//    パラメータ    ：    0:農業者老齢年金、1:特例付加年金(kind)
//                    0:減らす、1:増やす(mode)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/06    ohta
//
//#############################################################################
function changerecieveage(kind, mode){
    var age;
    
    age = document.entdata.recieveage[kind].value;
    if(kind == 1 && spflg == false){
        return false;
    }
    if(isNaN(age)){
        return false;
    }
    
    age= parseInt(age,10);
    
    switch(mode){
    case 0:
        age--;
        break;
        
    case 1:
        age++;
        break;
    }
    
    if(    (kind == 0 && age >= DEFINE_RECIEVEAGE0_LOWER  && age <= DEFINE_RECIEVEAGE0_UPPER) || 
        (kind == 1 && age >= DEFINE_RECIEVEAGE1_LOWER && age <= DEFINE_RECIEVEAGE1_UPPER)){
        //#VALUE値に代入
        document.entdata.recieveage[kind].value = age;
    }else{
        return false;
    }
    return true;
}
function AgedDate(byy, bmm, bdd, age) {
    //#35歳の到達年月を[YYYYMM]形式で表す
    amObj = new AgedMonth(byy, bmm, bdd, age);
    mydate = joinyearmonth(amObj.Year, amObj.Month);
    return mydate;
}
//#############################################################################
//    シミュレーションに関する動作
//#############################################################################
//#############################################################################
//
//    機能説明    ：    任意の年月日と生年月日よりその時点の年齢を算出する
//
//    パラメータ    ：    任意の年(yy)
//                    任意の月(mm)
//                    任意の日(dd)
//                    生まれた年(byy)
//                    生まれた月(bmm)
//                    生まれた日(bdd)
//                    
//
//    戻り値        ：    年齢(age)
//
//    変更履歴    ：    新規作成    2003/02/14    ohta
//
//#############################################################################
function calcage(yy, mm, dd, byy, bmm, bdd){
    var age;
    
    yy = parseInt(yy,10);
    mm = parseInt(mm,10);
    dd = parseInt(dd,10);
    byy = parseInt(byy,10);
    bmm = parseInt(bmm,10);
    bdd = parseInt(bdd,10);
    //#任意の月と生まれた月が等しい場合は
    //#生まれた日にかかわらず繰上げで誕生日を迎えたものとする    
    if(mm < bmm){
        age = yy - byy - 1;
    }else{
        age = yy - byy;
    }

    return age;
}
//#############################################################################
//
//    機能説明    ：    ある歳の到達年月および、その前月の年月を求める
//
//    パラメータ    ：    生まれた歳(byy)
//                    生まれた月(bmm)
//                    生まれた日(bdd)
//                    到達する歳(age)
//
//    属性        ：    到達年(Year)
//                    到達月(Month)
//                    到達年月の前月の年(FmrYear)
//                    到達年月の前月の月(FmrMonth)
//                    
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2003/02/14    ohta
//
//#############################################################################
function AgedMonth(byy, bmm, bdd, age){
    var DateObj, TransDateObj, ayy, amm;
    
    byy = parseInt(byy,10);
    bmm = parseInt(bmm,10);
    bdd = parseInt(bdd,10);
    age = parseInt(age,10);
        
    //age歳到達年月（誕生日の前日が含まれる月）算出
    DateObj = new Date(byy+age, bmm-1, bdd-1);
    ayy = DateObj.getFullYear();
    amm = DateObj.getMonth()+1;
    this.Year = ayy;
    this.Month = amm;
    
    //age歳到達年月の前月算出
    TransDateObj = new TransDate(ayy, amm, -1);
    this.FmrYear = TransDateObj.Year;
    this.FmrMonth = TransDateObj.Month;
}
//#############################################################################
//
//    機能説明    ：    年と月をつなげた数字[YYYYMM]を作る
//
//    パラメータ    ：    年(year)
//                    月(month)
//                    
//    戻り値        ：    年月をあらわす数字[YYYYMM](date)
//
//    変更履歴    ：    新規作成    2003/02/20    ohta
//
//#############################################################################
function joinyearmonth(year, month){
    var date;
    if(month < 10){
            date = parseInt(String(year) + "0" + String(month),10);
    }else{
            date = parseInt(String(year) + String(month),10);
    }
    
    return date;
}
//#############################################################################
//
//    機能説明    ：    納付年月と金額・入金年月と金額をそれぞれ配列に格納する
//
//    パラメータ    ：    納付年(year)
//                    納付月(month)
//                    納付金額(price)
//                    国庫補助金額(subsidy)
//                    配列の番号(cnt)
//                    
//    戻り値        ：    以下のデータを含んだ配列
//                    ・次の納付年
//                    ・次の納付月
//                    ・次の納付年月[YYYYMM]
//
//    変更履歴    ：    新規作成    2003/02/20    ohta
//
//#############################################################################
function inserttoarr(year, month, price, subsidy, cnt){
    var date, res;
    
    //#納付金額・年・月の配列作成
    payment[cnt] = new Array(price, year, month);
    
    //#入金金額・年・月（→納付年月の1月先）の配列作成
    TransDateObj = new TransDate(year, month, 1);
    receipt[0][cnt] = new Array(price, TransDateObj.Year, TransDateObj.Month);
    receipt[1][cnt] = new Array(subsidy, TransDateObj.Year, TransDateObj.Month);
    
    //#年月を1ヶ月送る
    year = TransDateObj.Year;
    month = TransDateObj.Month;
    date = joinyearmonth(year, month);
    res = new Array(year, month, date);
    return res;
}
//#############################################################################
//
//    機能説明    ：    年金の原資を求める
//
//    パラメータ    ：    想定される運用利回り(yld)
//                    自己[0]/国庫[1]判別フラグ(mode)
//
//    戻り値        ：    年金の原資
//
//    変更履歴    ：    新規作成    2003/02/21    ohta
//                    修正        2003/03/19    ohta
//
//#############################################################################
function calcprincipal(yld, mode){
    var reserve_fund;        //積立額
    var previous_term;        //期首残高
    var ave_balance;        //平均残高
    var interest;            //付利額
    var i, j, flg, times, temp, rate;
    var end_year, end_month;
    
    yld = parseFloat(yld);
    flg = true;
    
    //#実際の利率を算出
    for(j = 0; yld >= special_reserve[j][0] && special_reserve[j][0] != -1; j++);
    
    //#rete = yld - special_reserve[j][1] - special_reserve[j][2]
    rate = demicalcalc(demicalcalc(yld, "-", special_reserve[j][1]), "-", special_reserve[j][2]);
    
    //#運用期間の最後の年月を求める        
    end_year = (mode == 0)? parseInt(String(self_receive_date).substr(0,4),10) : parseInt(String(subsidy_receive_date).substr(0,4),10);
    end_month = (mode == 0)? parseInt(String(self_receive_date).substr(4,2),10) : parseInt(String(subsidy_receive_date).substr(4,2),10);
    
    //#期首残高の初期化
    previous_term = 0;
    i = 0;
    
    while(flg){
        //#初期化(一年度ごとに)
        reserve_fund = 0;
        temp = 0;
        
        if(    (end_month >= 4 && receipt[mode][i][1] < end_year)  || 
            (end_month <= 3 && receipt[mode][i][1] < end_year-1) ){
            
            //#翌年度の4月が来るか、入金が終了するまで保険料を足し合わせる (reserve_fund)    
            //#翌年度の4月が来るか、入金が終了するまで保険料に運用期間を掛けて足し合わせる(temp)
            if(receipt[mode][i][2] == 4){
                reserve_fund = previous_term + receipt[mode][i][0];
                temp = (previous_term * 12) + (receipt[mode][i][0] * 11);
                i++;
            }else{
                reserve_fund = previous_term;
                temp = previous_term * 12;
            }
    
            for(; receipt[mode][i][2] != 4 && receipt[mode][i][2] != -1; i++){
                reserve_fund += receipt[mode][i][0];
                
                switch(receipt[mode][i][2]){
                    case 4:times = 11;break;
                    case 5:times = 10;break;
                    case 6:times = 9;break;
                    case 7:times = 8;break;
                    case 8:times = 7;break;
                    case 9:times = 6;break;
                    case 10:times = 5;break;
                    case 11:times = 4;break;
                    case 12:times = 3;break;
                    case 1:times = 2;break;
                    case 2:times = 1;break;
                    case 3:times = 0;break;
                }
                temp += receipt[mode][i][0] * times;
            }
            
        }else{
            
            //#翌年度の4月が来るか、入金が終了するまで保険料を足し合わせる(reserve_fund)    
            //#翌年度の4月が来るか、入金が終了するまで保険料に運用期間を掛けて足し合わせる(temp)
            if(receipt[mode][i][2] == 4){
                reserve_fund = previous_term + receipt[mode][i][0];
                temp = (previous_term * (diffmonth(receipt[mode][i][1], receipt[mode][i][2], end_year, end_month)+1)) 
                        + (receipt[mode][i][0] * diffmonth(receipt[mode][i][1], receipt[mode][i][2], end_year, end_month));
                i++;
            }else{
                reserve_fund = previous_term;
                temp = previous_term * diffmonth(receipt[mode][i][1], receipt[mode][i][2], end_year, end_month);
            }
    
            for(; receipt[mode][i][2] != 4 && receipt[mode][i][2] != -1; i++){
                reserve_fund += receipt[mode][i][0];
                temp += receipt[mode][i][0] * diffmonth(receipt[mode][i][1], receipt[mode][i][2], end_year, end_month);
            }
        
        }    
        if(receipt[mode][i][2] == -1){
            flg = false;
        }
    
        //#ave_balance = temp/12（小数点第２位以上を対象にして円単位に切り上げる）
        ave_balance = roundup(demicalcalc(temp, "/", 12));
    
        //#interest = ave_balance * rate / 100（小数点第４位以上を対象にして円単位に切り捨てる）
        interest = rounddown(demicalcalc(demicalcalc(ave_balance, "*", rate), "/", 100));
    
        //#次回期首残高/年金の原資
        previous_term = reserve_fund + interest;
    }
    
    return previous_term;
}
//#############################################################################
//
//    機能説明    ：    入力値のエラーチェックを行う
//
//    パラメータ    ：    加入年(jy)
//                    加入月(jm)
//                    性別(sx)
//                    生まれた歳(by)
//                    生まれた月(bm)
//                    生まれた日(bd)
//                    想定される利回り(yld)
//                    旧制度に加入していたか[y:"1"、n:"0"](old)
//                    政策支援の種類(plc)
//                    保険料月額(pre)
//                    受給開始年齢－農業者老齢年金(rcva0)
//                    受給開始年齢－特例付加年金(rcva1)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/14    ohta
//
//#############################################################################
function errchk(jy, jm, sx, by, bm, bd, yld, old, plc, pre, pre2, pre3, rcva0, rcva1, chgfee1age, chgfee2age, suppTerm){
    var zero, date;
    
    jy = parseInt(jy,10);
    jm = parseInt(jm,10);
    sx = parseInt(sx,10);
    by = parseInt(by,10);
    bm = parseInt(bm,10);
    bd = parseInt(bd,10);
    yld = parseFloat(yld);
    old = parseInt(old,10);
    plc = parseInt(plc,10);
    pre = parseInt(pre,10);
    pre2 = parseInt(pre,10);
    pre3 = parseInt(pre,10);
    rcva0 = parseInt(rcva0,10);
    rcva1 = parseInt(rcva1,10);
    
    //#加入年月の入力値が暦に実在しない場合
    if(!isdate2(jy, jm, 1)){
        errmsg = DEFINE_MESSAGE_0;
        errflg = false;
        return false;
    }
    
    //#加入年月の入力値が平成15年4月～平成99年12月の範囲から外れた場合
    zero = (jm < 10)? "0" : "";
    var myMode = (textEra2019 == document.getElementById("text-subscription-ear").innerHTML) ? 2 : 1;
    date = parseInt(String(decodeera(jy, myMode)) + zero + String(jm),10);
    if(date < DEFINE_JOIN_FIRSTDATE || date > DEFINE_JOIN_FINALDATE){
        errmsg = DEFINE_MESSAGE_1;
        errflg = false;
        return false;
    }
        
        if (date > 201904 && myMode == 1) {
            errmsg = DEFINE_MESSAGE_20;
            errflg = false;
            return false;
        }
        //保険料下限引き下げの適用を令和４年１月より前の加入期間で受けようとしたとき
        if (date < 202201 && document.getElementById("join_b").checked == true) {
            errmsg = DEFINE_MESSAGE_22;
            errflg = false;
            return false;

        }
 
    //#生年月日の入力値が暦に実在しない場合
    // V1.03 和暦の選択値により、年齢計算を変更させる。 start
    waMode = document.entdata.wareki.options[document.entdata.wareki.selectedIndex].value;
    if(!isdate(by, bm, bd, waMode)){
        errmsg = DEFINE_MESSAGE_2;
        errflg = false;
        return false;
    }
    // V1.03 和暦の選択値により、年齢計算を変更させる。 end
    //#想定される運用利回りが適切でない場合
    if(!isyield(yld)){
        errmsg = DEFINE_MESSAGE_3;
        errflg = false;
        return false;
    }
    
    //#保険料月額が数字でない場合 →　入力画面で制御しているのでエラーチェック不要
/*    if(isNaN(String(pre))){
        errmsg = DEFINE_MESSAGE_4;
        errflg = false;
        return false;
    }
*/
   
   //#農業者老齢年金受給開始年齢が適切でない場合
    if(!isrecieveage(0, rcva0)){
        errmsg = DEFINE_MESSAGE_5;
        errflg = false;
        return false;
    }
  
  //#特例付加年金受給開始年齢が適切でない場合
    if(!isrecieveage(1, rcva1)){
        errmsg = DEFINE_MESSAGE_6;
        errflg = false;
        return false;
    }
/*    
    //#農業者老齢年金か、特例付加年金の受給開始年齢が64歳以下になっている場合
    if(spflg){
        if(rcva0 != rcva1) && 
            (parseInt(rcva0,10) <= DEFINE_RECIEVEAGE_ROUND_UPPER || parseInt(rcva1,10) <= DEFINE_RECIEVEAGE_ROUND_UPPER)){
            errmsg = DEFINE_MESSAGE_7;
            errflg = false;
            return false;
        }
    }
*/
    //#特例付加年金の受給開始年齢が農業者老齢年金よりも先になっている場合
    if(spflg){
//        if(rcva0 > rcva1){
//            errmsg = DEFINE_MESSAGE_7;
//            errflg = false;
//            return false;
//        }
    }
    
    //#旧制度に加入しておらず、且つ「加入区分６」を選択された場合
    if(old == 0 && plc == 6){
        errmsg = DEFINE_MESSAGE_15;
        errflg = false;
        return false;
    }

    var myMode = (textEra2019 == document.getElementById("text-subscription-ear").innerHTML) ? 2 : 1;    
    yy = decodeera(jy, myMode);
    waMode = parseInt(document.entdata.wareki.options[document.entdata.wareki.selectedIndex].value,10);
    var bby = decodeera(by, waMode);    
    var age = calcage(yy, jm, "1", bby, bm, bd);

    if (chgfee1age != "" && chgfee2age != "" && chgfee2age <= chgfee1age) {
      errmsg = DEFINE_MESSAGE_25;
      errflg = false;
      return false;
    }

    if (chgfee1age != "" && chgfee2age != "" && (age >= chgfee1age || age >= chgfee2age)) {
      errmsg = DEFINE_MESSAGE_23;
      errflg = false;
      return false;
    }

    var chgag = chgfee1age < chgfee2age ? chgfee2age : chgfee1age;
    if (suppTerm <= chgag) {
      errmsg = DEFINE_MESSAGE_24;
      errflg = false;
      return false;
    }
    return true;
}
//#############################################################################
//
//    機能説明    ：    加入年月と生年月日より加入時年齢を算出し、表示する
//
//    パラメータ    ：    加入年(yy)
//                    加入月(mm)
//                    加入日(dd)
//                    生まれた年(byy)
//                    生まれた月(bmm)
//                    生まれた日(bdd)
//                    
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/14    ohta
//
//#############################################################################
function setjoinage(yy, mm, dd, byy, bmm, bdd){
    var age;
    
    yy = parseInt(yy,10);
    mm = parseInt(mm,10);
    dd = parseInt(dd,10);
    byy = parseInt(byy,10);
    bmm = parseInt(bmm,10);
    bdd = parseInt(bdd,10);
    var myMode = (textEra2019 == document.getElementById("text-subscription-ear").innerHTML) ? 2 : 1;    
    yy = decodeera(yy, myMode);
    // V1.03 和暦の選択値により、年齢計算を変更させる。 start
    waMode = parseInt(document.entdata.wareki.options[document.entdata.wareki.selectedIndex].value,10);
    byy = decodeera(byy, waMode);
    // V1.03 和暦の選択値により、年齢計算を変更させる。 end
    age = calcage(yy, mm, dd, byy, bmm, bdd);
    
    //#加入時年齢 < 20ならばエラー
    if(age < DEFINE_JOIN_FIRSTAGE){
        errmsg = DEFINE_MESSAGE_8;
        errflg = false;
        return false;
    }
    
	//#加入時年齢 > 59ならばエラー
	if(age > DEFINE_JOIN_FINALAGE){
		errmsg = DEFINE_MESSAGE_9;
		errflg = false;
		return false;
	}
    
    //#加入時年齢 > 34 で加入方法Ｂ(保険料下限適用)を選択していたらエラー
    if(age > DEFINE_REDUCE_FINALAGE && document.getElementById("join_b").checked == true){
        errmsg = DEFINE_MESSAGE_4;
        errflg = false;
        return false;
    }

    //#VALUE値に代入;
    document.outdata.joinage.value = age;
    return true;
    
}
//#############################################################################
//
//    機能説明    ：    保険料を算出する
//
//    パラメータ  ：    加入年(yy)
//                    加入月(mm)
//                    生まれた年(byy)
//                    生まれた月(bmm)
//                    生まれた日(bdd)
//                    旧制度で加入していたか[y:"1"、n:"0"](old)
//                    保険料月額(pre)
//                    政策支援の種類(mode)
//                    農業者老齢年金受給開始年齢(rcva0)
//                    特例付加年金受給開始年齢(rcva1)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/14    ohta
//
//#############################################################################
function calcpremium(yy, mm, byy, bmm, bdd, old, pre, pre2, pre3, mode, rcva0, rcva1, chgAge1, chgAge2, chgPrem1, chgPrem2){

  if(!(chgAge1 == "" && chgPrem1 == "")) {
    if (chgAge1 != "" && chgPrem1.length < 2) {
      errmsg = DEFINE_MESSAGE_27;
      errflg = false;
      return false;
    } else if (chgAge1 == "" && chgPrem1.length > 1) {
      errmsg = DEFINE_MESSAGE_28;
      errflg = false;
      return false;
    } else if (chgAge1 == "" && chgPrem1.length == 1) {
      errmsg = DEFINE_MESSAGE_29;
      errflg = false;
      return false;
    }
  }

  if(!(chgAge2 == "" && chgPrem2 == "")) {
    if (chgAge2 != "" && chgPrem2.length < 2) {
      errmsg = DEFINE_MESSAGE_30;
      errflg = false;
      return false;
    } else if (chgAge2 == "" && chgPrem2.length > 1) {
      errmsg = DEFINE_MESSAGE_31;
      errflg = false;
      return false;
    } else if (chgAge2 == "" && chgPrem2.length == 1) {
      errmsg = DEFINE_MESSAGE_32;
      errflg = false;
      return false;
    }
  }

  if (chgPrem1 > '67' || chgPrem2 > '67') {
    errmsg = DEFINE_MESSAGE_21;
    errflg = false;
    return false;
  }

    var AMObj0, AMObj1, AMObj2, AMObj3, AMObj4, AMObj5;
    var TransDateObj0, TransDateObj1, TransDateObj2;
    var i, j, k, next, premium, premium2, premium3, price, subsidy, chgmoneyflg, chgdateflg;
    var year, month, date, date35, date40,  date60, borndate, splitdate, enddate;
    var zero_m, zero_d;
    var lastno, ex_year, ex_month, ex_date;
    
    yy = parseInt(yy,10);
    mm = parseInt(mm,10);
    byy = parseInt(byy,10);
    bmm = parseInt(bmm,10);
    bdd = parseInt(bdd,10);
    old = parseInt(old,10);
    pre = parseInt(pre,10);
    pre2 = parseInt(pre2,10);
    pre3 = parseInt(pre3,10);    
    mode = parseInt(mode,10);
    rcva0 = parseInt(rcva0);
    rcva1 = parseInt(rcva1);
    chgAge1 = parseInt(chgAge1,10);
    chgAge2 = parseInt(chgAge2,10);
    chgPrem1 = parseInt(chgPrem1,10);
    chgPrem2 = parseInt(chgPrem2,10);
    
        var myMode = (textEra2019 == document.getElementById("text-subscription-ear").innerHTML) ? 2 : 1;    
    yy = decodeera(yy, myMode);
    // V1.03 和暦の選択値により、年齢計算を変更させる。 start
    waMode = parseInt(document.entdata.wareki.options[document.entdata.wareki.selectedIndex].value,10);
    byy = decodeera(byy, waMode);
    // V1.03 和暦の選択値により、年齢計算を変更させる。 end
    chgmoneyflg = 0;
    chgdateflg = 0;
    
    if (document.getElementById("join_a").checked == true){
        premium = parseInt(String(pre) + "000",10);
        premium2 = "";
        premium3 = "";    
    }else if (document.getElementById("join_b").checked == true){
        premium2 = parseInt(String(pre2) + "000",10);
        premium3 = parseInt(String(pre3) + "000",10);
        premium = "";
    }
   
    //#加入年と月を[YYYYMM]形式で表す
    year = yy;
    month = mm;
    date = joinyearmonth(year, month);
    
    //#60歳の到達年月を[YYYYMM]形式で表す(date60)    
    //#60歳の到達年月日を含む月の前月を[YYYYMM]形式で表す(enddate)
    AMObj0 = new AgedMonth(byy, bmm, bdd, DEFINE_JOIN_FINALAGE+1);
    date60 = joinyearmonth(AMObj0.Year, AMObj0.Month);
    enddate = joinyearmonth(AMObj0.FmrYear, AMObj0.FmrMonth);

    //#35歳の到達年月を[YYYYMM]形式で表す
    AMObj1 = new AgedMonth(byy, bmm, bdd, DEFINE_POLICY_AGE_0);
    date35 = joinyearmonth(AMObj1.Year, AMObj1.Month);
    
    //#40歳の到達年月を[YYYYMM]形式であらわす
    AMObj2 = new AgedMonth(byy, bmm, bdd, DEFINE_POLICY_AGE_1+1);
    date40 = joinyearmonth(AMObj2.Year, AMObj2.Month);
    
    //#生年月日を[YYYYMMDD]形式であらわす
    zero_m = (parseInt(bmm,10) < 10)? "0" : "";
    zero_d = (parseInt(bdd,10) < 10)? "0" : "";
    borndate = parseInt(String(byy) + zero_m + String(bmm) + zero_d + String(bdd),10);
           
    //#加入年月が60歳の到達年月以降の場合
    if(date >= date60){
        errmsg = DEFINE_MESSAGE_10;
        errflg = false;
        return false;       
    }

    //#保険料2万円未満を選択しての加入年月が35歳の到達年月以降の場合
	if(date >= date35 && document.getElementById("join_b").checked == true){
		errmsg = DEFINE_MESSAGE_4;
		errflg = false;
		return false;
	}

    //#保険料月額が10000以上67000でない場合
     if (document.getElementById("join_a").checked == true && !(pre >= DEFINE_PREMIUM_LOWER && pre <= DEFINE_PREMIUM_UPPER)) {
        errmsg = DEFINE_MESSAGE_21;
        errflg = false;
        return false;
     }else if(document.getElementById("join_b").checked == true && !(pre3 >= DEFINE_PREMIUM_LOWER && pre3 <= DEFINE_PREMIUM_UPPER)){
        errmsg = DEFINE_MESSAGE_21;
        errflg = false;
        return false;

    }
    
    //##### 納付年月と金額の配列・入金年月と金額の配列をそれぞれつくる #####    
    //#政策支援ごとに処理を分岐するし、下限引き下げの計算は分岐外で行なう
    
    var jage = calcage(yy, mm, "1", byy, bmm, bdd);
    var ag = parseInt(jage);

    var ca1 = chgAge1;
    var ca2 = chgAge2;
    var cp1 = chgPrem1;
    var cp2 = chgPrem2;
    if(document.getElementById("join_a").checked == true){

        switch(mode){
        //#政策支援「通常加入」
        case 0:

            splitdate = enddate;
        
            //#配列の作成
            price = premium;
            subsidy = 0;

            for(i = 0; date <= splitdate; i++){
                if (i != 0 && month == bmm) ag++;
                
                var myprice = price;
                if (ag >= ca1) { myprice = cp1; price = parseInt(String(cp1) + "000",10); }
                if (ag >= ca2) { myprice = cp2; price = parseInt(String(cp2) + "000",10); }
                next = inserttoarr(year, month, price, subsidy, i);
                year = next[0];
                month = next[1];
                date = next[2];
            }
        break;

        //#政策支援「加入区分１」「加入区分２」「加入区分３」    
        case 1:
        case 2:
        case 3:
            //#生年月日が昭和22年1月2日以前で、旧制度で加入していた場合
            if(borndate < DEFINE_POLICY_DATE && old == 1){
              errmsg = DEFINE_MESSAGE_11;
              errflg = false;
              return false;        
            }

            //#加入年月が40歳の到達年月以降で、旧制度で加入していない場合
            if(date > date40 && old == 0){
                errmsg = DEFINE_MESSAGE_12;
                errflg = false;
                return false;    
            }

            var ca1date = AgedDate(byy, bmm, bdd, ca1);
            var ca2date = AgedDate(byy, bmm, bdd, ca2);

            //#加入年月が35歳の到達年月より前の場合
            if(date < date35){
                if (ca1date <= date40) {
                  errmsg = DEFINE_MESSAGE_26;
                  errflg = false;
                  return false;    
                }

                AMObj3 = new AgedMonth(byy, bmm, bdd, DEFINE_POLICY_AGE_0);
                splitdate = joinyearmonth(AMObj3.FmrYear, AMObj3.FmrMonth);
                price = DEFINE_POLICY1_MONEY_0;
                subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY1_MONEY_0;

                //#配列の作成
                for(j = 0, k = 0; k < 2; k++){            
                    for(i = j; date <= splitdate; i++){
                        if (i != 0 && month == bmm) ag++;
                        //#35歳を超えてから121ヶ月目 もしくは 加入時から241ヶ月目か？
                        if((chgdateflg == 1 && i-j+1 == DEFINE_POLICY_TERM_1 + 1) || i+1 == DEFINE_POLICY_TERM_0 + 1){
                            price = premium;
                            subsidy = 0;
                            chgmoneyflg++;
                            if (ca1 <= ag && i == DEFINE_POLICY_TERM_0) {
                              errmsg = DEFINE_MESSAGE_26;
                              errflg = false;
                              return false;    
                            }
                        }

                        if (ag >= ca1 && date >= date40) { price = parseInt(String(cp1) + "000",10); }
                        if (ag >= ca2 && date >= date40) { price = parseInt(String(cp2) + "000",10); }
                        next = inserttoarr(year, month, price, subsidy, i);
                        year = next[0];
                        month = next[1];
                        date = next[2];
                    }
                    price = DEFINE_POLICY1_MONEY_1;
                    subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY1_MONEY_1;
                    chgmoneyflg++;
                    splitdate = enddate;
                    chgdateflg++;
                    j = i;
                }

            //#加入年月が35歳の到達年月以降の場合
            }else{
                var d45 = AgedDate(byy, bmm, bdd, 45);
/*
                if (ca1date <= d45) {
                  errmsg = DEFINE_MESSAGE_26;
                  errflg = false;
                  return false;    
                }
*/

                splitdate = enddate;
                price = DEFINE_POLICY1_MONEY_1;
                subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY1_MONEY_1;

                //#配列の作成
                var m121flg = false;
                for(i = 0; date <= splitdate; i++){
                    if (i != 0 && month == bmm) ag++;
                    //#121ヶ月目か？
                    if(i+1 == DEFINE_POLICY_TERM_1 + 1){
                        price = premium;
                        subsidy = 0;
                        chgmoneyflg++;
                        m121flg = true;
                        if (ca1 <= ag) {
                          errmsg = DEFINE_MESSAGE_26;
                          errflg = false;
                          return false;    
                        }
                    }
                    if (ag >= ca1 && m121flg) { price = parseInt(String(cp1) + "000",10); }
                    if (ag >= ca2 && m121flg) { price = parseInt(String(cp2) + "000",10); }
                    next = inserttoarr(year, month, price, subsidy, i);    
                    year = next[0];
                    month = next[1];
                    date = next[2];
                }
            }
            break;

        //#政策支援「加入区分４」
        case 4:
            //#生年月日が昭和22年1月2日以前で、旧制度で加入していた場合
            if(borndate < DEFINE_POLICY_DATE && old == 1){
                errmsg = DEFINE_MESSAGE_11;
                errflg = false;
                return false;

            }

            //#加入年月が40歳の到達年月以降で、旧制度で加入していない場合
            if(date > date40 && old == 0){
                errmsg = DEFINE_MESSAGE_12;
                errflg = false;
                return false;

            }

            var ca1date = AgedDate(byy, bmm, bdd, ca1);
            var ca2date = AgedDate(byy, bmm, bdd, ca2);

            //#加入年月が35歳の到達年月より前の場合
            if(date < date35){
                if (ca1date <= date40) {
                  errmsg = DEFINE_MESSAGE_26;
                  errflg = false;
                  return false;    
                }

                AMObj3 = new AgedMonth(byy, bmm, bdd, DEFINE_POLICY_AGE_0);
                splitdate = joinyearmonth(AMObj3.FmrYear, AMObj3.FmrMonth);
                price = DEFINE_POLICY4_MONEY_0;
                subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY4_MONEY_0;

                //#配列の作成
                var m121flg = false;
                for(j = 0, k = 0; k < 2; k++){            
                    for(i = j; date <= splitdate; i++){
                        if (i != 0 && month == bmm) ag++;
                        //#35歳を超えないで37ヶ月目か？
                        if(chgdateflg == 0 && i+1 == DEFINE_POLICY4_TERM_0 + 1){
                            price = DEFINE_POLICY1_MONEY_0;
                            subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY1_MONEY_0;
                            chgmoneyflg++;

                        //#35歳を超えてから37ヶ月目か？
                        }else if(chgdateflg == 1 && i+1 == DEFINE_POLICY4_TERM_0 + 1){
                            price = DEFINE_POLICY1_MONEY_1;
                            subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY1_MONEY_1;
                            chgmoneyflg++;

                        //#35歳を超えてから121ヶ月目 もしくは 加入時から241ヶ月目か？
                        }else if((chgdateflg == 1 && i-j+1 == DEFINE_POLICY_TERM_1 + 1) || i+1 == DEFINE_POLICY_TERM_0 + 1){
                            price = premium;
                            subsidy = 0;
                            chgmoneyflg++;
                            m121flg = true;
                            if (ca1 <= ag && i == DEFINE_POLICY_TERM_0) {
                              errmsg = DEFINE_MESSAGE_26;
                              errflg = false;
                              return false;    
                            }
                        }
                        if (ag >= ca1 && m121flg) { price = parseInt(String(cp1) + "000",10); }
                        if (ag >= ca2 && m121flg) { price = parseInt(String(cp2) + "000",10); }
                        next = inserttoarr(year, month, price, subsidy, i);    
                        year = next[0];
                        month = next[1];
                        date = next[2];

                    }
                    if(chgmoneyflg == 1){
                        price = DEFINE_POLICY1_MONEY_1;
                        subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY1_MONEY_1;
                        chgmoneyflg++;

                    }else{
                        price = DEFINE_POLICY4_MONEY_1;
                        subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY4_MONEY_1;
                        chgmoneyflg++;

                    }
                    splitdate = enddate;
                    chgdateflg++;
                    j = i;
                }

            //#加入年月が35歳の到達年月以降の場合
            }else{
                var d45 = AgedDate(byy, bmm, bdd, 45);
/*
                if (ca1date <= d45) {
                  errmsg = DEFINE_MESSAGE_26;
                  errflg = false;
                  return false;    
                }
*/
                splitdate = enddate;
                price = DEFINE_POLICY4_MONEY_1;
                subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY4_MONEY_1;

                //#配列の作成
                var m121flg = false;
                for(i = 0; date <= splitdate; i++){
                    if (i != 0 && month == bmm) ag++;
                    //#37ヶ月目か？
                    if(i+1 == DEFINE_POLICY4_TERM_0 + 1){
                        price = DEFINE_POLICY1_MONEY_1;
                        subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY1_MONEY_1;
                        chgmoneyflg++;

                    //#121ヶ月目か？
                    }else if(i+1 == DEFINE_POLICY_TERM_1 + 1){
                        price = premium;
                        subsidy = 0;
                        chgmoneyflg++;
                        m121flg = true;
                        if (ca1 <= ag) {
                          errmsg = DEFINE_MESSAGE_26;
                          errflg = false;
                          return false;    
                        }
                    }
                    if (ag >= ca1 && m121flg) { price = parseInt(String(cp1) + "000",10); }
                    if (ag >= ca2 && m121flg) { price = parseInt(String(cp2) + "000",10); }
                    next = inserttoarr(year, month, price, subsidy, i);    
                    year = next[0];
                    month = next[1];
                    date = next[2];
                }
            }
            break;

        //#政策支援「加入区分５」    
        case 5:
            //#生年月日が昭和22年1月2日以前で、旧制度で加入していた場合
            if(borndate < DEFINE_POLICY_DATE && old == 1){
                errmsg = DEFINE_MESSAGE_11;
                errflg = false;
                return false;

            }

            //#加入年月が40歳の到達年月以降で、旧制度で加入していない場合
            if(date > date40 && old == 0){
                errmsg = DEFINE_MESSAGE_12;
                errflg = false;
                return false;

            }

            var ca1date = AgedDate(byy, bmm, bdd, ca1);
            var ca2date = AgedDate(byy, bmm, bdd, ca2);

            //#加入年月が35歳の到達年月より前の場合
            if(date < date35){
                if (ca1date <= date40) {
                  errmsg = DEFINE_MESSAGE_26;
                  errflg = false;
                  return false;    
                }

                AMObj3 = new AgedMonth(byy, bmm, bdd, DEFINE_POLICY_AGE_0);
                splitdate = joinyearmonth(AMObj3.FmrYear, AMObj3.FmrMonth);
                price = DEFINE_POLICY5_MONEY_0;
                subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY5_MONEY_0;

                //#配列の作成
                var m121flg = false;
                for(j = 0, k = 0; k < 2; k++){            
                    for(i = j; date <= splitdate; i++){
                        if (i != 0 && month == bmm) ag++;
                        //#35歳を超えないで121ヶ月目か？
                        if(chgdateflg == 0 && i+1 == DEFINE_POLICY5_TERM_0 + 1){
                            price = DEFINE_POLICY1_MONEY_0;
                            subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY1_MONEY_0;
                            chgmoneyflg++;
                            m121flg = true;
                        //#35歳を超えてから121ヶ月目 もしくは 加入時から241ヶ月目か？
                        }else if((chgdateflg == 1 && i-j+1 == DEFINE_POLICY_TERM_1 + 1) || i+1 == DEFINE_POLICY_TERM_0 + 1){
                            price = premium;
                            subsidy = 0;
                            chgmoneyflg++;
                            m121flg = true;
                            if (ca1 <= ag && i == DEFINE_POLICY_TERM_0) {
                              errmsg = DEFINE_MESSAGE_26;
                              errflg = false;
                              return false;    
                            }
                        }
                        if (ag >= ca1 && m121flg) { price = parseInt(String(cp1) + "000",10); }
                        if (ag >= ca2 && m121flg) { price = parseInt(String(cp2) + "000",10); }
                        next = inserttoarr(year, month, price, subsidy, i);
                        year = next[0];
                        month = next[1];
                        date = next[2];

                    }
                    price = DEFINE_POLICY1_MONEY_1;
                    subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY1_MONEY_1;
                    chgmoneyflg++;
                    splitdate = enddate;
                    chgdateflg++;
                    j = i;
                }

            //#加入年月が35歳の到達年月以降の場合
            }else{
                errmsg = DEFINE_MESSAGE_13;
                errflg = false;
                return false;

            }
            break;

        //#政策支援「加入区分６」    
        case 6:
            //#生年月日が昭和22年1月2日以前で、旧制度で加入していた場合
            if(borndate < DEFINE_POLICY_DATE && old == 1){
                errmsg = DEFINE_MESSAGE_11;
                errflg = false;
                return false;

            }

            //#加入年月が40歳の到達年月以降で、旧制度で加入していない場合
            if(date > date40 && old == 0){
                errmsg = DEFINE_MESSAGE_12;
                errflg = false;
                return false;

            }

            //#加入年月が2004年12月より後の場合
            if(date > DEFINE_POLICY6_FINALDATE){
                errmsg = DEFINE_MESSAGE_14;
                errflg = false;
                return false;

            }

            TransDateObj0 = 
                new TransDate(parseInt(String(DEFINE_POLICY6_FINALDATE).substr(0,4),10), parseInt(String(DEFINE_POLICY6_FINALDATE).substr(4,2),10),1);


            //#加入年月が35歳の到達年月より前の場合
            if(date < date35){
                AMObj3 = new AgedMonth(byy, bmm, bdd, DEFINE_POLICY_AGE_0);
                splitdate = joinyearmonth(AMObj3.FmrYear, AMObj3.FmrMonth);
                price = DEFINE_POLICY6_MONEY_0;
                subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY6_MONEY_0;

                //#配列の作成
                for(j = 0, k = 0; k < 2; k++){            
                    for(i = j; date <= splitdate; i++){
                        //#納付日が2005年1月か？
                        if(date == joinyearmonth(TransDateObj0.Year, TransDateObj0.Month)){
                            price = premium;
                            subsidy = 0;
                            chgmoneyflg++;
                        }
                        next = inserttoarr(year, month, price, subsidy, i);    
                        year = next[0];
                        month = next[1];
                        date = next[2];
                    }

                    if(chgmoneyflg == 0){
                        price = DEFINE_POLICY6_MONEY_1;
                        subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY6_MONEY_1;
                        chgmoneyflg++;

                    }
                    splitdate = enddate;
                    chgdateflg++;
                    j = i;
                }

            //#加入年月が35歳の到達年月以降
            }else if (document.getElementById("join_b").checked == true){
                splitdate = enddate;
                price = DEFINE_POLICY6_MONEY_1;
                subsidy = DEFINE_POLICY_MONEY_BASE - DEFINE_POLICY6_MONEY_1;

                console.log('TransDateObj0:');
                console.log(TransDateObj0);
                console.log(`splitdate = ${splitdate}`);
                //#配列の作成
                for(i = 0; date <= splitdate; i++){
                    //#納付日が2005年1月か？
                    if(date == joinyearmonth(TransDateObj0.Year, TransDateObj0.Month)){
                        price = premium;
                        subsidy = 0;
                        chgmoneyflg++;

                    }
                    next = inserttoarr(year, month, price, subsidy, i);    
                    year = next[0];
                    month = next[1];
                    date = next[2];
                }
            }
            break;
           
            }

        }else{
          console.log('join_b is checked!!!!!?');
          console.log(`date=${date}, date35=${date35}`);
        //#保険料下限引き下げ適用者
        if(date < date35){
            AMObj3 = new AgedMonth(byy, bmm, bdd, DEFINE_POLICY_AGE_0);
            splitdate = joinyearmonth(AMObj3.FmrYear, AMObj3.FmrMonth);
            console.log(`data=${date}, splitdate=${splitdate}, ca1=${ca1}`);
            price = premium2;
            subsidy = 0;                        
            //#配列の作成
            for(j = 0, k = 0; k < 2; k++){            
                for(i = j; date <= splitdate; i++){
                    if (i != 0 && month == bmm) ag++;
                    //#35歳以降60歳まで
                    console.log(`splitdate + 1 = ${splitdate+1}`);
                    if(chgdateflg == 1) {
                      if (date == splitdate + 1) {
                        price = premium3;
                        subsidy = 0;
                        chgmoneyflg++;
                      }
                      console.log(`ca1=${ca1}, ag=${ag}`);
			if (ag <= 35 && ca1 <= ag) {
                        errmsg = DEFINE_MESSAGE_26;
                        errflg = false;
                        return false;
                      }
                    }
                    if (ag >= ca1 && date > date35) { price = parseInt(String(cp1) + "000",10); }
                    if (ag >= ca2 && date > date35) { price = parseInt(String(cp2) + "000",10); }
                    console.log(`chgdateflg=${chgdateflg}, ca1=${ca1}, ag=${ag}, i=${i}, j=${j}, k=${k}, date=${date}, splitdate=${splitdate}, year = ${year}, month = ${month}, price = ${price}, subsidy = ${subsidy}`);
                    next = inserttoarr(year, month, price, subsidy, i);
                      year = next[0];
                        month = next[1];
                        date = next[2];

                  }
                  price = premium3;
                  subsidy = 0;
                  chgmoneyflg++;
                  splitdate = enddate;
                  chgdateflg++;
                  j = i;
               }
           }                
       }

    //#配列のターミネーターをつくる（要素はすべて-1）
    lastno = i;
    payment[lastno] = new Array(-1, -1, -1);
    
    //##運用が終了するまで、0円を支払続けるものとする
    //#農業者老齢年金の受給開始年齢の到達年月を[YYYYMM]形式で表す(self_receive_date:外部変数)
    AMObj4 = new AgedMonth(byy, bmm, bdd, rcva0);
    self_receive_date = joinyearmonth(AMObj4.Year, AMObj4.Month);
    
    //#特例付加年金の受給開始年齢の到達年月を[YYYYMM]形式で表す(subsidy_receive_date:外部変数)
    AMObj5 = new AgedMonth(byy, bmm, bdd, rcva1);
    subsidy_receive_date = joinyearmonth(AMObj5.Year, AMObj5.Month);
    
    for(j = 0; j <= 1; j++){
        TransDateObj1 = new TransDate(receipt[j][lastno-1][1], receipt[j][lastno-1][2],1);
        ex_year = TransDateObj1.Year;
        ex_month = TransDateObj1.Month;
        ex_date = joinyearmonth(ex_year, ex_month);    
        splitdate = (j == 0)? self_receive_date : subsidy_receive_date; 
        for(k = lastno; ex_date <= splitdate; k++){
            receipt[j][k] = new Array(0, ex_year, ex_month);
            TransDateObj2 = new TransDate(ex_year, ex_month, 1);
            ex_year = TransDateObj2.Year;
            ex_month = TransDateObj2.Month;
            ex_date = joinyearmonth(ex_year, ex_month);
        }
    
        receipt[j][k] = new Array(-1, -1, -1);
    }
    return true;
}
//#############################################################################
//
//    機能説明    ：    保険料を算出し、表示する
//
//    パラメータ    ：    加入年(yy)
//                    加入月(mm)
//                    生まれた年(byy)
//                    生まれた月(bmm)
//                    生まれた日(bdd)
//                    旧制度で加入していたか[y:"1"、n:"0"](old)
//                    保険料月額(pre)
//                    政策支援の種類(mode)
//                    農業者老齢年金受給開始年齢(rcva0)
//                    特例付加年金受給開始年齢(rcva1)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/14    ohta
//
//#############################################################################
function setpremium(yy, mm, byy, bmm, bdd, old, pre, pre2, pre3, mode, rcva0, rcva1, chgAge1, chgAge2, chgPrem1, chgPrem2){
    var fstprice;
    
    yy = parseInt(yy,10);
    mm = parseInt(mm,10);
    byy = parseInt(byy,10);
    bmm = parseInt(bmm,10);
    bdd = parseInt(bdd,10);
    old = parseInt(old,10);
    pre = parseInt(pre,10);
    pre2 = parseInt(pre2,10);
    pre3 = parseInt(pre3,10);
    mode = parseInt(mode,10);
    rcva0 = parseInt(rcva0,10);
    rcva1 = parseInt(rcva1,10);
    
    //#保険料を算出する
    if(!calcpremium(yy, mm, byy, bmm, bdd, old, pre, pre2, pre3, mode, rcva0, rcva1, chgAge1, chgAge2, chgPrem1, chgPrem2)){
        return false;
    }
    
    //#VALUE値を表示
    //#配列の最後尾(-1, -1, -1)までループ
    for(i = 0, j = 0; payment[i][0] != -1; j++){
        fstprice = payment[i][0];
        document.outdata.premiumyear_from[j].value = payment[i][1];
        document.outdata.premiummonth_from[j].value = payment[i][2];
        // V1.03 和暦の選択値により、年齢計算を変更させる。 start
        waMode = parseInt(document.entdata.wareki.options[document.entdata.wareki.selectedIndex].value,10);
        document.outdata.premiumage_from[j].value = 
            calcage(payment[i][1], payment[i][2], 1, decodeera(byy, waMode), bmm, bdd);
        // V1.03 和暦の選択値により、年齢計算を変更させる。 end
        //#保険料が変わるまでループ
        for(; payment[i][0] == fstprice; i++);
        document.outdata.premiumyear_to[j].value = payment[i-1][1];
        document.outdata.premiummonth_to[j].value = payment[i-1][2];
        // V1.03 和暦の選択値により、年齢計算を変更させる。 start
        document.outdata.premiumage_to[j].value = 
            calcage(payment[i-1][1], payment[i-1][2], 1, decodeera(byy, waMode), bmm, bdd);
        // V1.03 和暦の選択値により、年齢計算を変更させる。 end
        document.outdata.premiummoney[j].value = putcomma(fstprice);
    }
    return true;
    
}
//#############################################################################
//
//    機能説明    ：    年金額を算出・表示する
//
//    パラメータ    ：    性別(sx)
//                    想定される運用利回り(yld)
//                    農業者老齢年金受給開始年齢(rcva0)
//                    特例付加年金受給開始年齢(rcva1)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/21    ohta
//
//#############################################################################
function setpension(sx, yld, rcva0, rcva1){
    var principal, i, rcvage, coeff, temp;
    
    sx = parseInt(sx,10);
    yld = parseFloat(yld);
    rcva0 = parseInt(rcva0,10);
    rcva1 = parseInt(rcva1,10);
    
    price = new Array(1);
    principal = new Array(1);
        
    for(i = 0; i <= 1; i++){
        //#年金の原資を求める
        principal[i] = calcprincipal(yld, i);
        
        //#年金の年額を求める
        switch(i){
        case 0:
            coeff = selfpaid_coefficient[rcva0][sx];
            break;
            
        case 1:
            if(spflg){
                coeff = subsidy_coefficient[rcva1][sx];
            }
            break;
        }
        if(spflg || i != 1){
            price[i] = roundup2(demicalcalc(principal[i], "/", coeff));
        }
    }
    
    //#VALUE値を表示する
    with(document.outdata){
        //#特例付加年金を受けない場合
        if(!spflg){
            pensionage_from[0].value = rcva0;
/*            
            pensionage_to[0].value = rounddown2(exception_life[sx]);    
*/
            pensionmoney_fa[0].value = putcomma(price[0]);
            pensionmoney_sp[0].value = putcomma(0);
            pensionmoney_all[0].value = putcomma(price[0]);
            
            agechar.value = "";
        
        //#農業者老齢年金と特例付加年金の受給開始年齢が同じである場合    
        }else if(rcva0 == rcva1){
            pensionage_from[0].value = rcva0;
/*
            pensionage_to[0].value = rounddown2(exception_life[sx]);    
*/
            pensionmoney_fa[0].value = putcomma(price[0]);
            pensionmoney_sp[0].value = putcomma(price[1]);
            pensionmoney_all[0].value = putcomma(price[0] + price[1]);
            agechar.value = "";
                    
        //#農業者老齢年金が特例付加年金よりも先に受給開始され、
        //#且つ、農業者老齢年金と特例付加年金のどちらとも受給額が0円でない場合
        }else if(rcva0 < rcva1 && price[0] != 0 && price[1] != 0){
            pensionage_from[0].value = rcva0;
            pensionage_to.value = rcva1 - 1;
            pensionmoney_fa[0].value = putcomma(price[0]);
            pensionmoney_sp[0].value = putcomma(0);
            pensionmoney_all[0].value = putcomma(price[0]);
            
            agechar.value = "歳";
                        
            pensionage_from[1].value = rcva1;
/*
            pensionage_to[1].value = rounddown2(exception_life[sx]);
*/
            pensionmoney_fa[1].value = putcomma(price[0]);
            pensionmoney_sp[1].value = putcomma(price[1]);
            pensionmoney_all[1].value = putcomma(price[0] + price[1]);
        
        //#特例付加年金が農業者老齢年金よりも先に受給開始され、
        //#且つ、農業者老齢年金と特例付加年金のどちらとも受給額が0円でない場合
        }else if(rcva0 > rcva1 && price[0] != 0 && price[1] != 0){
            pensionage_from[0].value = rcva1;
            pensionage_to.value = rcva0 - 1;
            pensionmoney_fa[0].value = putcomma(0);
            pensionmoney_sp[0].value = putcomma(price[1]);
            pensionmoney_all[0].value = putcomma(price[1]);
            agechar.value = "歳";
                        
            pensionage_from[1].value = rcva0;
/*
            pensionage_to[1].value = rounddown2(exception_life[sx]);
*/
            pensionmoney_fa[1].value = putcomma(price[0]);
            pensionmoney_sp[1].value = putcomma(price[1]);
            pensionmoney_all[1].value = putcomma(price[0] + price[1]);
        
        //#以上のどれにも属さない場合 すなわち
        //#特例付加年金を受け、
        //#農業者老齢年金と特例付加年金の受給開始年齢はそれぞれ異なり、
        //#且つ、農業者老齢年金と特例付加年金の受給額のどちらかが0円である場合
        }else{
            temp = (rcva0 < rcva1)? rcva0 : rcva1;
            
            pensionage_from[0].value = temp;
/*            
            pensionage_to[0].value = rounddown2(exception_life[sx]);    
*/
            pensionmoney_fa[0].value = putcomma(price[0]);
            pensionmoney_sp[0].value = putcomma(price[1]);
            pensionmoney_all[0].value = putcomma(price[0] + price[1]);
            
            agechar.value = "";
        }
    }
}
//#############################################################################
//
//    機能説明    ：    保険料総額を算出・表示する
//
//    パラメータ    ：    なし
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/21    ohta
//
//#############################################################################
function setpremium_all(){
    var i, allpremium;
    
    for(i = 0, allpremium = 0; payment[i][0] != -1; i++){
        allpremium += payment[i][0];     
    }
    
    //#VALUE値を表示する    
    document.outdata.premiummoney_all.value = putcomma(allpremium);
    
    return true;
}
//#############################################################################
//
//    機能説明    ：    平均的な年金受給総額を算出・表示する
//
//    パラメータ    ：    性別[0:男性、1:女性](sx)
//                    農業者老齢年金受給開始年齢(rcva0)
//                    特例付加年金受給開始年齢(rcva1)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/24    ohta
//
//#############################################################################
function setpension_all(sx, rcva0, rcva1){
    var oldage_pension, special_pension;
    
    sx = parseInt(sx,10);
    rcva0 = parseInt(rcva0,10);
    rcva1 = parseInt(rcva1,10);
    
    oldage_pension = 
        roundup2(demicalcalc(price[0], "*", demicalcalc(exception_life[sx], "-", rcva0)));
    if(spflg){
        special_pension =
            roundup2(demicalcalc(price[1], "*", demicalcalc(exception_life[sx], "-", rcva1)));
    }else{
        special_pension = 0;
    }
    
    //#VALUE値を表示する
    with(document.outdata){
        pensionmoney_fa_ave.value = putcomma(oldage_pension);
        pensionmoney_sp_ave.value = putcomma(special_pension);
        pensionmoney_all_ave.value = putcomma(oldage_pension + special_pension);
    }
}
//#############################################################################
//
//    機能説明    ：    シミュレーションを実行する
//
//    パラメータ    ：    なし
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2003/02/06    ohta
//
//#############################################################################
function simulation(){
    //#################### 初期設定 ####################
    var jy, jm, sx, by, bm, bd, yld, old, plc, pre, pre2, pre3, rcva0, rcva1;
    var i, next;
    var sei, mei, seikana, meikana;
    var on, onk;
    errflg = true;    //#エラーフラグの初期値設定
    errmsg = "";    //#エラーメッセージの初期値設定
    payment = new Array();
    receipt = new Array();
    receipt[0] = new Array();
    receipt[1] = new Array();
    self_receive_date = null;        //#農業者老齢年金の受給開始年月の初期化
    subsidy_receive_date = null;    //#特例付加年金の受給開始年月の初期化
    
    pre = "";
    pre2 = "";
    pre3 = "";

    chgfee1age = "";
    chgfee2age = "";

    mySupplyTerm = "";
        
    //#入力値を変数に保存
    with(document.entdata){
        jy = joinyear.value;
        jm = joinmonth.value;
        for(i = 0;i < sex.length; i++){
            if(sex[i].checked){
                sx = sex[i].value;
            }
        }
        by = birthyear.value;
        bm = birthmonth.value;
        bd = birthday.value;
        yld = yield.value;
        for(i = 0;i < oldtype.length; i++){
            if(oldtype[i].checked){
                old = oldtype[i].value;
            }
        }
        
        if(document.getElementById("join_a").checked == true){
            plc = policy.value;
        }/*else{
            plc = policy2.value;
        }*/
        
        if(document.getElementById("join_a").checked == true){
            for(i = 0; i < premium.length; i++){
                pre = pre + premium[i].options[premium[i].selectedIndex].value;
                pre2 = "";
                pre3 = "";
            }
        }else if (document.getElementById("join_b").checked == true){
            for(i = 0; i < premium2.length; i++){
                pre2 = pre2+ premium2[i].options[premium2[i].selectedIndex].value;
            }
            for(i = 0; i < premium3.length; i++){
                pre3 = pre3 + premium3[i].options[premium3[i].selectedIndex].value;
                pre = "";
            }
        }
        
        rcva0 = recieveage[0].value;
        rcva1 = recieveage[1].value;
        
        sei = lastname.value;
        mei = firstname.value;
        seikana = lastnamekana.value;
        meikana = firstnamekana.value;

        chgfee1age = changefee1age.value;
        chgfee2age = changefee2age.value;
        mySupplyTerm = hidepremium30.value;

        chgPrem1 = changefee1man.value + changefee1sen.value;
        chgPrem2 = changefee2man.value + changefee2sen.value;
    }
    
    //#出力フォームのリセット
    document.outdata.reset();
    
    //########### 姓名の入力値チェックを実行 ###########
    namechk(sei, mei, seikana, meikana);
    
    //############ シミュレーションスタート ############
    for(next = 0; next <= 5; next++){
        //#nextがインクリメントするたびに順次処理を行う
        switch(next){
        case 0://#入力値エラーチェック
            errchk(jy, jm, sx, by, bm, bd, yld, old, plc, pre, pre2, pre3, rcva0, rcva1, chgfee1age, chgfee2age, mySupplyTerm);
            break;
        
        case 1://#加入時年齢算出・表示
            setjoinage(jy, jm, "1", by, bm, bd);
            break;
        
        case 2://#保険料算出・表示
            setpremium(jy, jm, by, bm, bd, old, pre, pre2, pre3, plc, rcva0, rcva1, chgfee1age, chgfee2age, chgPrem1, chgPrem2);
            break;
                
        case 3: //#年金額算出・表示
            setpension(sx, yld, rcva0, rcva1);
            break;
        
        case 4: //#保険料総額算出・表示
            setpremium_all();
            break;
        
        case 5: //#平均的な年金受給総額算出・表示
            setpension_all(sx, rcva0, rcva1);
            break;
        }
        
        //#エラー発生時は警告を出し、
        //#そこでシミュレーションは中止する
        if(!errflg){
            //#出力フォームのリセット
            document.outdata.reset();
            alert(errmsg);
            return false;
        }
    }
    
    with(document.outdata){
        if(sei== "" && mei =="" && seikana == "" && meikana==""){
            on = "";
            onk = "";
            
            document.getElementById("resultTitle1").style.display="none";
            document.getElementById("resultTitle2").style.display="";
        }else{
            
            on = " " + sei + " " + mei;
            onk = "  " + seikana + " " + meikana;
            
            document.getElementById("resultTitle1").style.display="";
            document.getElementById("resultTitle2").style.display="none";
        }
        outname.value = on;
        outnamekana.value = onk;
    }
    
   window.location.href = "./simulator.html#output"; 
    return true;
    
}
//#############################################################################
//    その他
//#############################################################################
//#############################################################################
//
//    機能説明    ：    政策支援フローチャート表示
//
//    パラメータ    ：    なし
//
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2003/02/10    ohta
//
//#############################################################################
function openwin(){
    var param;
    
    //#ウインドウ属性指定
    param = "toolbar=no,";
    param = param + "location=no,";
    param = param + "directories=no,";
    param = param + "status=no,";
    param = param + "menubar=no,";
    param = param + "scrollbars=no,";
    param = param + "resizable=yes,";
    param = param + "width=600,";
    param = param + "height=450";
    
    polwin = window.open("./policymap.html", "PolicyMap", param);
    polwin.focus();
}
//#############################################################################
//
//    機能説明    ：    政策支援フローチャートウィンドウのクローズ
//
//    パラメータ    ：    なし
//
//    戻り値        ：    なし
//
//    変更履歴    ：    新規作成    2003/02/26    ohta
//
//#############################################################################
function closewin(){
    if(polwin != null){
        polwin.close();
    }
}
//#############################################################################
//
//    機能説明    ：    姓名・姓名（カナ）の入力値チェック
//
//    パラメータ    ：    姓(sei)
//                    名(mei)
//                    姓カナ(seikana)
//                    名カナ(meikana)
//
//    戻り値        ：    true/false
//
//    変更履歴    ：    新規作成    2012/02/06    yoda
//
//#############################################################################
function namechk(sei, mei, seikana, meikana){

	//#姓・名に半角文字が入力された場合
	if (sei.match(/[ -~|｡-ﾟ]/) != null || mei.match(/[ -~|｡-ﾟ]/) != null){
		errmsg = DEFINE_MESSAGE_16;
		errflg = false;
		return false;
	}
	
	//#姓・名（カナ）のみが入力された場合
	if(sei == "" && seikana != "" || mei == "" && meikana != ""){
		errmsg = DEFINE_MESSAGE_17;
		errflg = false;
		return false;
	}
	
	//#姓・名（カナ）にカタカナ以外が入力された場合
	if(seikana != "" && !seikana.match(/^[ァ-ン]+$/) || meikana != "" && !meikana.match(/^[ァ-ン]+$/)){
		errmsg = DEFINE_MESSAGE_18;
		errflg = false;
		return false;
	}
	
	//#姓・名、姓・名(カナ）が上限値以上入力された場合
	if(sei.length > DEFINE_NAME_LENGTH){
		errmsg = DEFINE_MESSAGE_19.replace("?1", "姓").replace("?2", DEFINE_NAME_LENGTH);
		errflg = false;
		return false;
	}else if(mei.length > DEFINE_NAME_LENGTH){
		errmsg = DEFINE_MESSAGE_19.replace("?1", "名").replace("?2", DEFINE_NAME_LENGTH);
		errflg = false;
		return false;
	}else if(seikana.length > DEFINE_NAME_KANA_LENGTH){
		errmsg = DEFINE_MESSAGE_19.replace("?1", "姓（カナ）").replace("?2", DEFINE_NAME_KANA_LENGTH);
		errflg = false;
		return false;
	}else if(meikana.length > DEFINE_NAME_KANA_LENGTH){
		errmsg = DEFINE_MESSAGE_19.replace("?1", "名（カナ）").replace("?2", DEFINE_NAME_KANA_LENGTH);
		errflg = false;
		return false;
	}
	return true;
}
